/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaUpgradeIndexCheck
extends BaseJavaTermCheck {
    private static final Pattern _pattern = Pattern.compile("(create|drop) (unique )?index IX_(?!TEMP)");

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        JavaClass javaClass = (JavaClass)javaTerm;
        List<String> extendedClassNames = javaClass.getExtendedClassNames();
        if (extendedClassNames.contains("UpgradeProcess")) {
            Matcher matcher = _pattern.matcher(fileContent);
            while (matcher.find()) {
                this.addMessage(fileName, StringBundler.concat("Do not execute '", matcher.group(), "' in upgrade classes"), this.getLineNumber(fileContent, matcher.start()));
            }
        }
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }
}

