/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaSystemExceptionCheck
extends BaseFileCheck {
    private static final Pattern _throwsSystemExceptionPattern = Pattern.compile("(\n\t+.*)throws(.*) SystemException(.*)( \\{|;\n)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (content.contains("SystemException")) {
            content = this._fixSystemExceptions(content);
        }
        return content;
    }

    private String _fixSystemExceptions(String content) {
        Matcher matcher = _throwsSystemExceptionPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String match = matcher.group();
        String replacement = null;
        String afterException = matcher.group(3);
        String beforeException = matcher.group(2);
        if (Validator.isNull(beforeException) && Validator.isNull(afterException)) {
            replacement = matcher.group(4);
            String beforeThrows = matcher.group(1);
            if (Validator.isNotNull(StringUtil.trim(beforeThrows))) {
                replacement = beforeThrows + replacement;
            }
        } else {
            replacement = Validator.isNull(beforeException) ? StringUtil.replaceFirst(match, "SystemException, ", "") : StringUtil.replaceFirst(match, ", SystemException", "");
        }
        if (match.equals(replacement)) {
            return content;
        }
        return this._fixSystemExceptions(StringUtil.replaceFirst(content, match, replacement));
    }
}

