/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseJSPTermsCheck;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPMissingTaglibsCheck
extends BaseJSPTermsCheck {
    private static final Pattern _tagPattern = Pattern.compile("<(aui|c|chart|clay|display|liferay(-[\\w-]+)|portlet|soy):");

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (absolutePath.contains("/custom_jsps/") || absolutePath.contains("-fragment/")) {
            return content;
        }
        Set<String> taglibPrefixes = this._getTaglibPrefixes(content);
        if (taglibPrefixes.isEmpty()) {
            return content;
        }
        this.populateContentsMap(fileName, content);
        Set<String> missingTaglibPrefixes = this.getMissingTaglibPrefixes(fileName, taglibPrefixes);
        for (String prefix : missingTaglibPrefixes) {
            this.addMessage(fileName, "Missing taglib for tag with prefix '" + prefix + "'");
        }
        return content;
    }

    private Set<String> _getTaglibPrefixes(String content) {
        HashSet<String> taglibPrefixes = new HashSet<String>();
        Matcher matcher = _tagPattern.matcher(content);
        while (matcher.find()) {
            taglibPrefixes.add(matcher.group(1));
        }
        return taglibPrefixes;
    }
}

