/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseLineBreakCheck;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPLineBreakCheck
extends BaseLineBreakCheck {
    private static final Pattern _missingLineBreakPattern = Pattern.compile("([\n\t]((?!<%)[^\n\t])+?) *(%>[\"']\n)");
    private static final Pattern _redundantCommaPattern = Pattern.compile(",\n\t*\\}");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            String previousLine = "";
            boolean javaSource = false;
            boolean jsSource = false;
            int lineNumber = 0;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                ++lineNumber;
                String trimmedLine = StringUtil.trimLeading(line);
                if (trimmedLine.equals("<%") || trimmedLine.equals("<%!")) {
                    javaSource = true;
                } else if (trimmedLine.equals("%>")) {
                    javaSource = false;
                } else if (trimmedLine.equals("<aui:script>") || trimmedLine.startsWith("<aui:script ") || trimmedLine.equals("<script>") || trimmedLine.startsWith("<script ")) {
                    jsSource = true;
                } else if (trimmedLine.equals("</aui:script>") || trimmedLine.equals("</script>")) {
                    jsSource = false;
                }
                if (!(line.startsWith("#") || jsSource && !javaSource)) {
                    this.checkLineBreaks(line, previousLine, fileName, lineNumber);
                }
                previousLine = line;
            }
        }
        Matcher matcher = _missingLineBreakPattern.matcher(content);
        content = matcher.replaceAll("$1\n$3");
        return this._fixRedundantCommaInsideArray(content);
    }

    private String _fixRedundantCommaInsideArray(String content) {
        Matcher matcher = _redundantCommaPattern.matcher(content);
        while (matcher.find()) {
            if (!this.isJavaSource(content, matcher.start())) continue;
            return StringUtil.replaceFirst(content, ",", "", matcher.start());
        }
        return content;
    }
}

