/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.BNDSourceUtil;
import java.util.List;

public class BNDSuiteCheck
extends BaseFileCheck {
    private static final String _ALLOWED_FILE_NAMES_KEY = "allowedFileNames";
    private static final String _ALLOWED_LIFERAY_RELENG_SUITE_NAMES_KEY = "allowedLiferayRelengSuiteNames";

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws ReflectiveOperationException {
        String[] lines;
        if (!absolutePath.endsWith("/app.bnd")) {
            return content;
        }
        List<String> allowedFileNames = this.getAttributeValues(_ALLOWED_FILE_NAMES_KEY, absolutePath);
        for (String allowedFileName : allowedFileNames) {
            if (!absolutePath.endsWith(allowedFileName)) continue;
            return content;
        }
        if (content.matches("(?s).*Liferay-Releng-Deprecated:\\s*true.*")) {
            content = BNDSourceUtil.updateInstruction(content, "Liferay-Releng-Suite", "");
            if (ReleaseInfo.getBuildNumber() >= 7100 && content.matches("(?s).*Liferay-Releng-Marketplace:\\s*false.*")) {
                this.addMessage(fileName, "Deprecated apps that are not published on Marketplace should be moved to the archived folder");
            }
        }
        List<String> allowedLiferayRelengSuiteNames = this.getAttributeValues(_ALLOWED_LIFERAY_RELENG_SUITE_NAMES_KEY, absolutePath);
        for (String line : lines = StringUtil.splitLines(content)) {
            if (!line.contains("Liferay-Releng-Suite")) continue;
            String s = StringUtil.removeSubstring(line, "Liferay-Releng-Suite:");
            String value = StringUtil.toLowerCase(s.trim());
            if (Validator.isNull(value)) {
                content = BNDSourceUtil.updateInstruction(content, "Liferay-Releng-Fix-Delivery-Method", "");
                content = BNDSourceUtil.updateInstruction(content, "Liferay-Releng-Portal-Required", "false");
                continue;
            }
            if (!allowedLiferayRelengSuiteNames.isEmpty() && !allowedLiferayRelengSuiteNames.contains(value)) {
                String message = StringBundler.concat("The 'Liferay-Releng-Suite' can be blank or one of the ", "following values '", StringUtil.merge(allowedLiferayRelengSuiteNames, ", "), "'");
                this.addMessage(fileName, message);
                continue;
            }
            content = BNDSourceUtil.updateInstruction(content, "Liferay-Releng-Bundle", "true");
            content = BNDSourceUtil.updateInstruction(content, "Liferay-Releng-Fix-Delivery-Method", "core");
            content = BNDSourceUtil.updateInstruction(content, "Liferay-Releng-Marketplace", "true");
            content = BNDSourceUtil.updateInstruction(content, "Liferay-Releng-Portal-Required", "true");
            content = BNDSourceUtil.updateInstruction(content, "Liferay-Releng-Suite", value);
        }
        if (!content.contains("Liferay-Releng-Suite:")) {
            content = content + "\nLiferay-Releng-Suite:";
        }
        return content;
    }
}

