/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.poshi.core.PoshiContext;
import com.liferay.poshi.core.elements.PoshiElement;
import com.liferay.poshi.core.elements.PoshiNodeFactory;
import com.liferay.poshi.core.script.PoshiScriptParserException;
import com.liferay.poshi.core.util.FileUtil;
import com.liferay.source.formatter.BaseSourceProcessor;
import com.liferay.source.formatter.SourceFormatterArgs;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.util.DebugUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;

public class PoshiSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**/*.function", "**/*.macro", "**/*.testcase"};
    private static boolean _populated;

    @Override
    protected List<String> doGetFileNames() throws IOException {
        return this.getFileNames(new String[0], this.getIncludes());
    }

    @Override
    protected String[] doGetIncludes() {
        return _INCLUDES;
    }

    @Override
    protected File format(File file, String fileName, String absolutePath, String content) throws Exception {
        if (SourceUtil.isXML(content)) {
            return file;
        }
        return super.format(file, fileName, absolutePath, content);
    }

    @Override
    protected String parse(File file, String fileName, String content, Set<String> modifiedMessages) throws Exception {
        this._populateFunctionAndMacroFiles();
        PoshiElement poshiElement = (PoshiElement)PoshiNodeFactory.newPoshiNodeFromFile(FileUtil.getURL(file));
        PoshiScriptParserException.throwExceptions(SourceUtil.getAbsolutePath(file));
        String newContent = poshiElement.toPoshiScript();
        if (!content.equals(newContent)) {
            modifiedMessages.add(file.toString() + " (PoshiParser)");
            SourceFormatterArgs sourceFormatterArgs = this.getSourceFormatterArgs();
            if (sourceFormatterArgs.isShowDebugInformation()) {
                DebugUtil.printContentModifications("PoshiParser", fileName, content, newContent);
            }
        }
        return newContent;
    }

    private synchronized void _populateFunctionAndMacroFiles() {
        if (_populated) {
            return;
        }
        List<String> functionAndMacroFileNames = SourceFormatterUtil.filterFileNames(this.getAllFileNames(), new String[0], new String[]{"**/*.function", "**/*.macro"}, this.getSourceFormatterExcludes(), true);
        for (String fileName : functionAndMacroFileNames) {
            if (fileName.endsWith(".function")) {
                PoshiContext.setFunctionFileNames(fileName.replaceFirst(".+/(.+)\\.function", "$1"));
                continue;
            }
            if (!fileName.endsWith(".macro")) continue;
            PoshiContext.setMacroFileNames(fileName.replaceFirst(".+/(.+)\\.macro", "$1"));
        }
        _populated = true;
    }
}

