/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassUtil {
    private static final String _CLASS_EXTENSION = ".class";
    private static final Log _log = LogFactoryUtil.getLog(ClassUtil.class);
    private static final Pattern _annotationNamePattern = Pattern.compile("@(\\w+)\\.?(\\w*)$");
    private static final Pattern _annotationParametersPattern = Pattern.compile("@(\\w+)\\.?(\\w*)\\({0,1}\\{{0,1}([^)}]+)\\}{0,1}\\){0,1}");

    public static Set<String> getClasses(File file) throws IOException {
        String fileName = file.getName();
        if (fileName.endsWith(".java")) {
            fileName = fileName.substring(0, fileName.length() - 5);
        }
        return ClassUtil.getClasses(new UnsyncBufferedReader(new FileReader(file)), fileName);
    }

    public static Set<String> getClasses(Reader reader, String className) throws IOException {
        HashSet<String> classes = new HashSet<String>();
        StreamTokenizer st = new StreamTokenizer(reader);
        ClassUtil._setupParseTableForAnnotationProcessing(st);
        while (st.nextToken() != -1) {
            String[] annotationClasses;
            if (st.ttype != -3) continue;
            if (st.sval.equals("class") || st.sval.equals("enum") || st.sval.equals("interface") || st.sval.equals("@interface")) break;
            if (!st.sval.startsWith("@")) continue;
            st.ordinaryChar(32);
            st.wordChars(61, 61);
            st.wordChars(43, 43);
            st.wordChars(45, 45);
            for (String annotationClass : annotationClasses = ClassUtil._processAnnotation(st.sval, st)) {
                classes.add(annotationClass);
            }
            ClassUtil._setupParseTableForAnnotationProcessing(st);
        }
        ClassUtil._setupParseTable(st);
        while (st.nextToken() != -1) {
            if (st.ttype == -3) {
                int lastIndex;
                int firstIndex = st.sval.indexOf(46);
                if (firstIndex >= 0) {
                    classes.add(st.sval.substring(0, firstIndex));
                }
                if ((lastIndex = st.sval.lastIndexOf(46)) >= 0) {
                    classes.add(st.sval.substring(lastIndex + 1));
                }
                if (firstIndex >= 0) continue;
                classes.add(st.sval);
                continue;
            }
            if (st.ttype == -2 || st.ttype == 10 || !Character.isUpperCase((char)st.ttype)) continue;
            classes.add(String.valueOf((char)st.ttype));
        }
        classes.remove(className);
        return classes;
    }

    public static String getClassName(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        return clazz.getName();
    }

    public static String getParentPath(ClassLoader classLoader, String className) {
        if (_log.isDebugEnabled()) {
            _log.debug("Class name " + className);
        }
        if (!className.endsWith(_CLASS_EXTENSION)) {
            className = className + _CLASS_EXTENSION;
        }
        className = StringUtil.replace(className, '.', '/');
        className = StringUtil.replace(className, "/class", _CLASS_EXTENSION);
        URL url = classLoader.getResource(className);
        Path path = Paths.get(ClassUtil._getPathURIFromURL(url));
        String parentPath = StringUtil.replace(path.toString(), '\\', '/');
        int pos = parentPath.indexOf(className);
        parentPath = parentPath.substring(0, pos);
        if (_log.isDebugEnabled()) {
            _log.debug("Parent path " + parentPath);
        }
        return parentPath;
    }

    public static boolean isSubclass(Class<?> a, Class<?> b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        for (Class<?> x = a; x != null; x = x.getSuperclass()) {
            Class<?>[] interfaceClasses;
            if (x == b) {
                return true;
            }
            if (!b.isInterface()) continue;
            for (Class<?> interfaceClass : interfaceClasses = x.getInterfaces()) {
                if (!ClassUtil.isSubclass(interfaceClass, b)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSubclass(Class<?> a, String s) {
        if (a == null || s == null) {
            return false;
        }
        String name = a.getName();
        if (name.equals(s)) {
            return true;
        }
        for (Class<?> x = a; x != null; x = x.getSuperclass()) {
            Class<?>[] interfaceClasses;
            name = x.getName();
            if (name.equals(s)) {
                return true;
            }
            for (Class<?> interfaceClass : interfaceClasses = x.getInterfaces()) {
                if (!ClassUtil.isSubclass(interfaceClass, s)) continue;
                return true;
            }
        }
        return false;
    }

    private static URI _getPathURIFromURL(URL url) {
        String path;
        String urlProtocol = url.getProtocol();
        if (urlProtocol.equals("jar") || urlProtocol.equals("wsjar")) {
            try {
                url = new URL(url.getPath());
            }
            catch (MalformedURLException malformedURLException) {
                throw new SystemException(malformedURLException);
            }
        }
        if (!(path = url.getPath()).startsWith("/")) {
            path = "/" + path;
        }
        try {
            URI uri = new URI("file:" + path);
            if (_log.isDebugEnabled()) {
                _log.debug("URI " + uri);
            }
            return uri;
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new SystemException(uriSyntaxException);
        }
    }

    private static String[] _processAnnotation(String s, StreamTokenizer st) throws IOException {
        s = s.trim();
        List<String> tokens = new ArrayList<String>();
        Matcher annotationNameMatcher = _annotationNamePattern.matcher(s);
        Matcher annotationParametersMatcher = _annotationParametersPattern.matcher(s);
        if (annotationNameMatcher.matches()) {
            tokens.add(annotationNameMatcher.group(1));
        } else if (annotationParametersMatcher.matches()) {
            tokens.add(annotationParametersMatcher.group(1));
            String annotationParameters = null;
            String trimmedString = s.trim();
            if (trimmedString.endsWith(")")) {
                annotationParameters = annotationParametersMatcher.group(3);
            } else {
                annotationParameters = s.substring(s.indexOf(40));
                while (st.nextToken() != -1) {
                    int openParenthesesCount;
                    int closeParenthesesCount;
                    if (st.ttype != -3) continue;
                    annotationParameters = annotationParameters + st.sval;
                    String trimmedValue = StringUtil.trim(st.sval);
                    if (!trimmedValue.endsWith(")") || (closeParenthesesCount = StringUtil.count(annotationParameters, ')')) != (openParenthesesCount = StringUtil.count(annotationParameters, '('))) continue;
                    break;
                }
            }
            tokens = ClassUtil._processAnnotationParameters(annotationParameters, tokens);
        }
        return tokens.toArray(new String[0]);
    }

    private static List<String> _processAnnotationParameters(String s, List<String> tokens) throws IOException {
        StreamTokenizer st = new StreamTokenizer(new UnsyncStringReader(s));
        ClassUtil._setupParseTable(st);
        while (st.nextToken() != -1) {
            if (st.ttype != -3) continue;
            if (st.sval.indexOf(46) >= 0) {
                tokens.add(st.sval.substring(0, st.sval.indexOf(46)));
                continue;
            }
            tokens.add(st.sval);
        }
        return tokens;
    }

    private static void _setupParseTable(StreamTokenizer st) {
        st.resetSyntax();
        st.slashSlashComments(true);
        st.slashStarComments(true);
        st.wordChars(97, 122);
        st.wordChars(65, 90);
        st.wordChars(46, 46);
        st.wordChars(48, 57);
        st.wordChars(95, 95);
        st.lowerCaseMode(false);
        st.eolIsSignificant(false);
        st.quoteChar(34);
        st.quoteChar(39);
        st.parseNumbers();
    }

    private static void _setupParseTableForAnnotationProcessing(StreamTokenizer st) {
        ClassUtil._setupParseTable(st);
        st.wordChars(64, 64);
        st.wordChars(40, 40);
        st.wordChars(41, 41);
        st.wordChars(123, 123);
        st.wordChars(125, 125);
        st.wordChars(44, 44);
    }
}

