/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.checks.util.TaglibUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaParameter;
import com.liferay.source.formatter.parser.JavaSignature;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Element;

public class JavaTaglibMethodCheck
extends BaseJavaTermCheck {
    private static final Pattern _setterMethodPattern = Pattern.compile("^_(\\w+)\\s*=\\s*\\1;$");
    private List<String> _allFileNames;
    private final Map<String, List<JavaClass>> _extendedTagJavaClassesMap = new ConcurrentHashMap<String, List<JavaClass>>();
    private final Map<String, List<JavaMethod>> _javaMethodsMap = new ConcurrentHashMap<String, List<JavaMethod>>();
    private Map<String, List<String>> _tagAttributesMap;
    private String _utilTaglibSrcDirName;

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    public void setAllFileNames(List<String> allFileNames) {
        this._allFileNames = allFileNames;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws Exception {
        JavaClass javaClass = (JavaClass)javaTerm;
        String className = javaClass.getName();
        if (!className.endsWith("Tag")) {
            return javaTerm.getContent();
        }
        List<JavaClass> extendedTagJavaClasses = this._getExtendedTagJavaClasses(javaClass, absolutePath);
        if (!this._containsClass(extendedTagJavaClasses, "com.liferay.taglib.util.IncludeTag") || extendedTagJavaClasses == null) {
            return javaTerm.getContent();
        }
        List<String> tagAttributeNames = this._getTagAttributeNames(javaClass.getPackageName(), javaClass.getName());
        if (tagAttributeNames == null) {
            return javaTerm.getContent();
        }
        List<JavaMethod> javaMethods = this._getJavaMethods(javaClass, extendedTagJavaClasses);
        for (String tagAttributeName : tagAttributeNames) {
            String getterMethodContent;
            String expectedGetterMethodName;
            JavaMethod getterJavaMethod;
            JavaParameter javaParameter;
            JavaMethod setterJavaMethod = this._getJavaMethod(javaMethods, "set" + tagAttributeName);
            if (setterJavaMethod == null) {
                this.addMessage(fileName, "Missing getter/setter methods for attribute '" + tagAttributeName + "'");
                continue;
            }
            if (setterJavaMethod.hasAnnotation("Deprecated") || (javaParameter = this._getJavaParameter(setterJavaMethod)) == null || (getterJavaMethod = this._getJavaMethod(javaMethods, expectedGetterMethodName = StringUtil.replaceFirst(setterJavaMethod.getName(), "set", "get"))) != null || StringUtil.equalsIgnoreCase(javaParameter.getParameterType(), "boolean") && (getterJavaMethod = this._getJavaMethod(javaMethods, expectedGetterMethodName = StringUtil.replaceFirst(setterJavaMethod.getName(), "set", "is"))) != null) continue;
            JavaClass setterMethodJavaClass = setterJavaMethod.getParentJavaClass();
            if (Objects.equals(javaClass.getName(true), setterMethodJavaClass.getName(true)) && (getterMethodContent = this._constructGetterMethodContent(setterJavaMethod.getContent(), javaParameter.getParameterType(), expectedGetterMethodName)) != null) {
                this._extendedTagJavaClassesMap.clear();
                this._javaMethodsMap.clear();
                return StringUtil.replaceLast(javaTerm.getContent(), '}', getterMethodContent + "}");
            }
            this.addMessage(fileName, "Missing getter method for attribute '" + tagAttributeName + "'");
        }
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }

    private String _constructGetterMethodContent(String setterMethodContent, String attributeType, String getterMethodName) {
        int y;
        int x = setterMethodContent.indexOf(123);
        String setterMethodBody = StringUtil.trim(setterMethodContent.substring(x + 1, y = setterMethodContent.lastIndexOf(125)));
        Matcher matcher = _setterMethodPattern.matcher(setterMethodBody);
        if (!matcher.find()) {
            return null;
        }
        StringBundler sb = new StringBundler(9);
        sb.append("public ");
        sb.append(attributeType);
        sb.append(" ");
        sb.append(getterMethodName);
        sb.append("() {\n");
        sb.append("return _");
        sb.append(matcher.group(1));
        sb.append(";\n");
        sb.append("}\n");
        return sb.toString();
    }

    private boolean _containsClass(List<JavaClass> javaClasses, String className) {
        for (JavaClass javaClass : javaClasses) {
            if (!className.equals(javaClass.getName(true))) continue;
            return true;
        }
        return false;
    }

    private synchronized List<JavaClass> _getExtendedTagJavaClasses(JavaClass javaClass, String absolutePath) throws Exception {
        List<JavaClass> extendedTagJavaClasses = this._extendedTagJavaClassesMap.get(absolutePath);
        if (extendedTagJavaClasses != null) {
            return extendedTagJavaClasses;
        }
        return this._getExtendedTagJavaClasses(javaClass, absolutePath, this._getUtilTaglibSrcDirName());
    }

    private List<JavaClass> _getExtendedTagJavaClasses(JavaClass javaClass, String absolutePath, String utilTaglibSrcDirName) throws Exception {
        List<String> extendedTagFileNames = TaglibUtil.getExtendedTagFileNames(javaClass, absolutePath, utilTaglibSrcDirName);
        if (extendedTagFileNames.isEmpty()) {
            this._extendedTagJavaClassesMap.put(absolutePath, Collections.emptyList());
            return Collections.emptyList();
        }
        ArrayList<JavaClass> extendedTagJavaClasses = new ArrayList<JavaClass>();
        for (String extendedTagFileName : extendedTagFileNames) {
            File extendedTagFile = new File(extendedTagFileName);
            if (!extendedTagFile.exists()) continue;
            String extendedTagContent = FileUtil.read(extendedTagFile);
            JavaClass extendedTagJavaClass = JavaClassParser.parseJavaClass(extendedTagFileName, extendedTagContent);
            extendedTagJavaClasses.add(extendedTagJavaClass);
            extendedTagJavaClasses.addAll(this._getExtendedTagJavaClasses(extendedTagJavaClass, extendedTagFileName, utilTaglibSrcDirName));
        }
        this._extendedTagJavaClassesMap.put(absolutePath, extendedTagJavaClasses);
        return extendedTagJavaClasses;
    }

    private JavaMethod _getJavaMethod(List<JavaMethod> javaMethods, String name) {
        for (JavaMethod javaMethod : javaMethods) {
            if (!StringUtil.equalsIgnoreCase(javaMethod.getName(), name)) continue;
            return javaMethod;
        }
        return null;
    }

    private synchronized List<JavaMethod> _getJavaMethods(JavaClass javaClass) {
        String className = javaClass.getName(true);
        List<JavaMethod> javaMethods = this._javaMethodsMap.get(className);
        if (javaMethods != null) {
            return javaMethods;
        }
        javaMethods = new ArrayList<JavaMethod>();
        for (JavaTerm javaTerm : javaClass.getChildJavaTerms()) {
            if (!javaTerm.isJavaMethod()) continue;
            javaMethods.add((JavaMethod)javaTerm);
        }
        this._javaMethodsMap.put(className, javaMethods);
        return javaMethods;
    }

    private List<JavaMethod> _getJavaMethods(JavaClass javaClass, List<JavaClass> extendedTagJavaClasses) {
        ArrayList<JavaMethod> javaMethods = new ArrayList<JavaMethod>();
        javaMethods.addAll(this._getJavaMethods(javaClass));
        for (JavaClass extendedTagJavaClass : extendedTagJavaClasses) {
            javaMethods.addAll(this._getJavaMethods(extendedTagJavaClass));
        }
        return javaMethods;
    }

    private JavaParameter _getJavaParameter(JavaMethod setterJavaMethod) {
        JavaSignature javaSignature = setterJavaMethod.getSignature();
        List<JavaParameter> javaParameters = javaSignature.getParameters();
        if (javaParameters.size() == 1) {
            return javaParameters.get(0);
        }
        return null;
    }

    private synchronized List<String> _getTagAttributeNames(String packageName, String className) throws Exception {
        String fullyQualifiedClassName = StringBundler.concat(packageName, ".", className);
        if (this._tagAttributesMap != null) {
            return this._tagAttributesMap.get(fullyQualifiedClassName);
        }
        this._tagAttributesMap = new HashMap<String, List<String>>();
        List<String> tldFileNames = TaglibUtil.getTLDFileNames(this.getBaseDirName(), this._allFileNames, this.getSourceFormatterExcludes(), this.isPortalSource(), this.getMaxDirLevel());
        if (tldFileNames.isEmpty()) {
            return this._tagAttributesMap.get(fullyQualifiedClassName);
        }
        for (String tldFileName : tldFileNames) {
            tldFileName = StringUtil.replace(tldFileName, '\\', '/');
            File tldFile = new File(tldFileName);
            String content = FileUtil.read(tldFile);
            Document document = SourceUtil.readXML(content);
            Element rootElement = document.getRootElement();
            List tagElements = rootElement.elements("tag");
            for (Element tagElement : tagElements) {
                Element tagClassElement = tagElement.element("tag-class");
                String tagClassName = tagClassElement.getStringValue();
                if (!tagClassName.startsWith("com.liferay")) continue;
                ArrayList<String> tagAttributeNames = new ArrayList<String>();
                List attributeElements = tagElement.elements("attribute");
                for (Element attributeElement : attributeElements) {
                    Element attributeNameElement = attributeElement.element("name");
                    tagAttributeNames.add(attributeNameElement.getStringValue());
                }
                this._tagAttributesMap.put(tagClassName, tagAttributeNames);
            }
        }
        return this._tagAttributesMap.get(fullyQualifiedClassName);
    }

    private synchronized String _getUtilTaglibSrcDirName() {
        if (this._utilTaglibSrcDirName != null) {
            return this._utilTaglibSrcDirName;
        }
        this._utilTaglibSrcDirName = TaglibUtil.getUtilTaglibSrcDirName(this.getBaseDirName(), this.getMaxDirLevel());
        return this._utilTaglibSrcDirName;
    }
}

