/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.json.JSONArrayImpl;
import com.liferay.portal.json.JSONObjectImpl;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.tools.GitException;
import com.liferay.portal.tools.GitUtil;
import com.liferay.source.formatter.BNDRunSourceProcessor;
import com.liferay.source.formatter.BNDSourceProcessor;
import com.liferay.source.formatter.CQLSourceProcessor;
import com.liferay.source.formatter.CSSSourceProcessor;
import com.liferay.source.formatter.CodeownersSourceProcessor;
import com.liferay.source.formatter.ConfigSourceProcessor;
import com.liferay.source.formatter.DTDSourceProcessor;
import com.liferay.source.formatter.DockerfileSourceProcessor;
import com.liferay.source.formatter.ExcludeSyntax;
import com.liferay.source.formatter.ExcludeSyntaxPattern;
import com.liferay.source.formatter.FTLSourceProcessor;
import com.liferay.source.formatter.GradleSourceProcessor;
import com.liferay.source.formatter.GroovySourceProcessor;
import com.liferay.source.formatter.HTMLSourceProcessor;
import com.liferay.source.formatter.JSONSourceProcessor;
import com.liferay.source.formatter.JSPSourceProcessor;
import com.liferay.source.formatter.JSSourceProcessor;
import com.liferay.source.formatter.JavaSourceProcessor;
import com.liferay.source.formatter.LFRBuildSourceProcessor;
import com.liferay.source.formatter.MarkdownSourceProcessor;
import com.liferay.source.formatter.PackageinfoSourceProcessor;
import com.liferay.source.formatter.PoshiSourceProcessor;
import com.liferay.source.formatter.ProgressStatus;
import com.liferay.source.formatter.ProgressStatusUpdate;
import com.liferay.source.formatter.PropertiesSourceProcessor;
import com.liferay.source.formatter.PythonSourceProcessor;
import com.liferay.source.formatter.SHSourceProcessor;
import com.liferay.source.formatter.SQLSourceProcessor;
import com.liferay.source.formatter.SourceFormatterArgs;
import com.liferay.source.formatter.SourceFormatterExcludes;
import com.liferay.source.formatter.SourceFormatterMessage;
import com.liferay.source.formatter.SourceMismatchException;
import com.liferay.source.formatter.SourceProcessor;
import com.liferay.source.formatter.SoySourceProcessor;
import com.liferay.source.formatter.TLDSourceProcessor;
import com.liferay.source.formatter.TSSourceProcessor;
import com.liferay.source.formatter.TXTSourceProcessor;
import com.liferay.source.formatter.XMLSourceProcessor;
import com.liferay.source.formatter.YMLSourceProcessor;
import com.liferay.source.formatter.checks.configuration.ConfigurationLoader;
import com.liferay.source.formatter.checks.configuration.SourceCheckConfiguration;
import com.liferay.source.formatter.checks.configuration.SourceFormatterConfiguration;
import com.liferay.source.formatter.checks.configuration.SourceFormatterSuppressions;
import com.liferay.source.formatter.checks.configuration.SuppressionsLoader;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.util.CheckType;
import com.liferay.source.formatter.util.DebugUtil;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.JIRAUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import java.io.File;
import java.io.FileInputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;

public class SourceFormatter {
    public static final ExcludeSyntaxPattern[] DEFAULT_EXCLUDE_SYNTAX_PATTERNS = new ExcludeSyntaxPattern[]{new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/.git/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/.gradle/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/.idea/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/.m2/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/.settings/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/bin/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/build/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/classes/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/liferay-theme.json"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/npm-shrinkwrap.json"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/package-lock.json"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/test-classes/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/test-coverage/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/test-results/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/tmp/**"), new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, "**/node_modules_cache/**"), new ExcludeSyntaxPattern(ExcludeSyntax.REGEX, "^((?!/frontend-js-node-shims/src/).)*/node_modules/.*")};
    private static final String _PROPERTIES_FILE_NAME = "source-formatter.properties";
    private static final int _SUBREPOSITORY_MAX_DIR_LEVEL = 3;
    private List<String> _allFileNames;
    private int _maxStatusMessageLength = -1;
    private final List<String> _modifiedFileNames = new CopyOnWriteArrayList<String>();
    private List<String> _pluginsInsideModulesDirectoryNames;
    private boolean _portalSource;
    private final BlockingQueue<ProgressStatusUpdate> _progressStatusQueue = new LinkedBlockingQueue<ProgressStatusUpdate>();
    private final Thread _progressStatusThread = new Thread(){

        @Override
        public void run() {
            int fileScansCompletedCount = 0;
            int percentage = 0;
            int processedChecksFileCount = 0;
            int totalChecksFileCount = 0;
            boolean checksInitialized = false;
            while (true) {
                try {
                    while (true) {
                        ProgressStatusUpdate progressStatusUpdate;
                        ProgressStatus progressStatus;
                        if ((progressStatus = (progressStatusUpdate = (ProgressStatusUpdate)SourceFormatter.this._progressStatusQueue.take()).getProgressStatus()).equals((Object)ProgressStatus.CHECKS_INITIALIZED)) {
                            totalChecksFileCount += progressStatusUpdate.getCount();
                            if (++fileScansCompletedCount != SourceFormatter.this._sourceProcessors.size()) continue;
                            checksInitialized = true;
                            totalChecksFileCount -= processedChecksFileCount;
                            processedChecksFileCount = 0;
                            continue;
                        }
                        if (progressStatus.equals((Object)ProgressStatus.CHECK_FILE_COMPLETED)) {
                            ++processedChecksFileCount;
                            if (!checksInitialized) continue;
                            percentage = this._processCompletedPercentage(percentage, processedChecksFileCount, totalChecksFileCount);
                            continue;
                        }
                        if (progressStatus.equals((Object)ProgressStatus.SOURCE_FORMAT_COMPLETED)) break;
                    }
                    if (SourceFormatter.this._maxStatusMessageLength == -1) break;
                    StringBundler sb = new StringBundler(SourceFormatter.this._maxStatusMessageLength);
                    for (int i = 0; i < SourceFormatter.this._maxStatusMessageLength; ++i) {
                        sb.append(' ');
                    }
                    SourceFormatter.this._printProgressStatusMessage(sb.toString());
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        private int _processCompletedPercentage(int percentage, int count, int total) {
            int newPercentage = count * 100 / total;
            if (newPercentage > percentage) {
                SourceFormatter.this._printProgressStatusMessage("Processing checks: " + newPercentage + "% completed");
            }
            return newPercentage;
        }
    };
    private String _projectPathPrefix;
    private Map<String, Properties> _propertiesMap;
    private final SourceFormatterArgs _sourceFormatterArgs;
    private SourceFormatterConfiguration _sourceFormatterConfiguration;
    private SourceFormatterExcludes _sourceFormatterExcludes;
    private final Set<SourceFormatterMessage> _sourceFormatterMessages = new ConcurrentSkipListSet<SourceFormatterMessage>();
    private SourceFormatterSuppressions _sourceFormatterSuppressions;
    private final List<SourceMismatchException> _sourceMismatchExceptions = new CopyOnWriteArrayList<SourceMismatchException>();
    private final List<SourceProcessor> _sourceProcessors = new ArrayList<SourceProcessor>();
    private boolean _subrepository;

    public static void main(String[] args) throws Exception {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        try {
            Object[] sourceFormatterProperties;
            SourceFormatterArgs sourceFormatterArgs = new SourceFormatterArgs();
            sourceFormatterArgs.setAutoFix(ArgumentsUtil.getBoolean(arguments, "source.auto.fix", true));
            String baseDirName = ArgumentsUtil.getString(arguments, "source.base.dir", "./");
            sourceFormatterArgs.setBaseDirName(baseDirName);
            sourceFormatterArgs.setCheckCategoryNames(ListUtil.fromString(ArgumentsUtil.getString(arguments, "source.check.category.names", null), ","));
            sourceFormatterArgs.setCheckNames(ListUtil.fromString(ArgumentsUtil.getString(arguments, "source.check.names", null), ","));
            sourceFormatterArgs.setFailOnAutoFix(ArgumentsUtil.getBoolean(arguments, "source.fail.on.auto.fix", false));
            sourceFormatterArgs.setFailOnHasWarning(ArgumentsUtil.getBoolean(arguments, "source.fail.on.has.warning", true));
            sourceFormatterArgs.setFormatCurrentBranch(ArgumentsUtil.getBoolean(arguments, "format.current.branch", false));
            sourceFormatterArgs.setFormatLatestAuthor(ArgumentsUtil.getBoolean(arguments, "format.latest.author", false));
            sourceFormatterArgs.setFormatLocalChanges(ArgumentsUtil.getBoolean(arguments, "format.local.changes", false));
            sourceFormatterArgs.setGitWorkingBranchName(ArgumentsUtil.getString(arguments, "git.working.branch.name", "master"));
            int commitCount = ArgumentsUtil.getInteger(arguments, "commit.count", 0);
            sourceFormatterArgs.setCommitCount(commitCount);
            if (commitCount > 0) {
                sourceFormatterArgs.addRecentChangesFileNames(GitUtil.getModifiedFileNames(baseDirName, commitCount), baseDirName);
            } else if (sourceFormatterArgs.isFormatCurrentBranch()) {
                sourceFormatterArgs.addRecentChangesFileNames(GitUtil.getCurrentBranchFileNames(baseDirName, sourceFormatterArgs.getGitWorkingBranchName(), false), baseDirName);
            } else if (sourceFormatterArgs.isFormatLatestAuthor()) {
                sourceFormatterArgs.addRecentChangesFileNames(GitUtil.getLatestAuthorFileNames(baseDirName, false), baseDirName);
            } else if (sourceFormatterArgs.isFormatLocalChanges()) {
                sourceFormatterArgs.addRecentChangesFileNames(GitUtil.getLocalChangesFileNames(baseDirName, false), baseDirName);
            }
            Object[] fileNames = StringUtil.split(ArgumentsUtil.getString(arguments, "source.files", ""), ",");
            if (ArrayUtil.isNotEmpty(fileNames)) {
                sourceFormatterArgs.setFileNames(Arrays.asList(fileNames));
            } else {
                String fileExtensionsString = ArgumentsUtil.getString(arguments, "source.file.extensions", "");
                String[] fileExtensions = StringUtil.split(fileExtensionsString, ",");
                sourceFormatterArgs.setFileExtensions(Arrays.asList(fileExtensions));
            }
            sourceFormatterArgs.setIncludeGeneratedFiles(ArgumentsUtil.getBoolean(arguments, "include.generated.files", false));
            boolean includeSubrepositories = ArgumentsUtil.getBoolean(arguments, "include.subrepositories", false);
            for (String recentChangesFileName : sourceFormatterArgs.getRecentChangesFileNames()) {
                if (!recentChangesFileName.endsWith("ci-merge")) continue;
                includeSubrepositories = true;
                break;
            }
            sourceFormatterArgs.setIncludeSubrepositories(includeSubrepositories);
            sourceFormatterArgs.setMaxLineLength(ArgumentsUtil.getInteger(arguments, "max.line.length", 80));
            sourceFormatterArgs.setMaxDirLevel(Math.max(7, StringUtil.count(baseDirName, '/') + 1));
            sourceFormatterArgs.setOutputFileName(ArgumentsUtil.getString(arguments, "output.file.name", SourceFormatterArgs.OUTPUT_FILE_NAME));
            sourceFormatterArgs.setPrintErrors(ArgumentsUtil.getBoolean(arguments, "source.print.errors", true));
            sourceFormatterArgs.setProcessorThreadCount(ArgumentsUtil.getInteger(arguments, "processor.thread.count", 5));
            sourceFormatterArgs.setShowDebugInformation(ArgumentsUtil.getBoolean(arguments, "show.debug.information", false));
            sourceFormatterArgs.setShowDocumentation(ArgumentsUtil.getBoolean(arguments, "show.documentation", false));
            sourceFormatterArgs.setShowStatusUpdates(ArgumentsUtil.getBoolean(arguments, "show.status.updates", false));
            Object[] skipCheckNames = StringUtil.split(ArgumentsUtil.getString(arguments, "skip.check.names", ""), ",");
            if (ArrayUtil.isNotEmpty(skipCheckNames)) {
                sourceFormatterArgs.setSkipCheckNames(Arrays.asList(skipCheckNames));
            }
            if (ArrayUtil.isNotEmpty(sourceFormatterProperties = StringUtil.split(ArgumentsUtil.getString(arguments, "source.formatter.properties", ""), "\\n"))) {
                sourceFormatterArgs.setSourceFormatterProperties(Arrays.asList(sourceFormatterProperties));
            }
            sourceFormatterArgs.setValidateCommitMessages(ArgumentsUtil.getBoolean(arguments, "validate.commit.messages", false));
            SourceFormatter sourceFormatter = new SourceFormatter(sourceFormatterArgs);
            sourceFormatter.format();
        }
        catch (Exception exception) {
            if (exception instanceof GitException) {
                System.out.println(exception.getMessage());
            } else {
                CheckstyleException checkstyleException = SourceFormatter._getNestedCheckstyleException(exception);
                if (checkstyleException != null) {
                    checkstyleException.printStackTrace();
                } else {
                    exception.printStackTrace();
                }
            }
            System.exit(1);
        }
    }

    public SourceFormatter(SourceFormatterArgs sourceFormatterArgs) {
        this._sourceFormatterArgs = sourceFormatterArgs;
        if (sourceFormatterArgs.isShowDocumentation()) {
            System.setProperty("java.awt.headless", "false");
        } else {
            System.setProperty("java.awt.headless", "true");
        }
    }

    public void format() throws Exception {
        String string;
        this._printProgressStatusMessage("Scanning for files...");
        System.setProperty("javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
        this._init();
        if (this._sourceFormatterArgs.isValidateCommitMessages()) {
            this._validateCommitMessages();
        }
        this._printProgressStatusMessage("Initializing checks...");
        this._progressStatusThread.setDaemon(true);
        this._progressStatusThread.setName("Source Formatter Progress Status Thread");
        this._progressStatusThread.start();
        this._sourceProcessors.add(new BNDRunSourceProcessor());
        this._sourceProcessors.add(new BNDSourceProcessor());
        this._sourceProcessors.add(new CodeownersSourceProcessor());
        this._sourceProcessors.add(new ConfigSourceProcessor());
        this._sourceProcessors.add(new CQLSourceProcessor());
        this._sourceProcessors.add(new CSSSourceProcessor());
        this._sourceProcessors.add(new DockerfileSourceProcessor());
        this._sourceProcessors.add(new DTDSourceProcessor());
        this._sourceProcessors.add(new LFRBuildSourceProcessor());
        this._sourceProcessors.add(new FTLSourceProcessor());
        this._sourceProcessors.add(new GradleSourceProcessor());
        this._sourceProcessors.add(new GroovySourceProcessor());
        this._sourceProcessors.add(new HTMLSourceProcessor());
        this._sourceProcessors.add(new JavaSourceProcessor());
        this._sourceProcessors.add(new JSONSourceProcessor());
        this._sourceProcessors.add(new JSPSourceProcessor());
        this._sourceProcessors.add(new JSSourceProcessor());
        this._sourceProcessors.add(new MarkdownSourceProcessor());
        this._sourceProcessors.add(new PackageinfoSourceProcessor());
        this._sourceProcessors.add(new PoshiSourceProcessor());
        this._sourceProcessors.add(new PropertiesSourceProcessor());
        this._sourceProcessors.add(new PythonSourceProcessor());
        this._sourceProcessors.add(new SHSourceProcessor());
        this._sourceProcessors.add(new SoySourceProcessor());
        this._sourceProcessors.add(new SQLSourceProcessor());
        this._sourceProcessors.add(new TLDSourceProcessor());
        this._sourceProcessors.add(new TSSourceProcessor());
        this._sourceProcessors.add(new TXTSourceProcessor());
        this._sourceProcessors.add(new XMLSourceProcessor());
        this._sourceProcessors.add(new YMLSourceProcessor());
        ExecutorService executorService = Executors.newFixedThreadPool(this._sourceProcessors.size());
        ArrayList<Future> futures = new ArrayList<Future>(this._sourceProcessors.size());
        for (final SourceProcessor sourceProcessor : this._sourceProcessors) {
            Future future = executorService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    SourceFormatter.this._runSourceProcessor(sourceProcessor);
                    return null;
                }
            });
            futures.add(future);
        }
        ExecutionException executionException1 = null;
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (ExecutionException executionException2) {
                if (executionException1 == null) {
                    executionException1 = executionException2;
                    continue;
                }
                executionException1.addSuppressed(executionException2);
            }
        }
        executorService.shutdown();
        while (!executorService.isTerminated()) {
            Thread.sleep(20L);
        }
        if (this._sourceFormatterArgs.isShowDebugInformation()) {
            DebugUtil.printSourceFormatterInformation();
        }
        this._progressStatusQueue.put(new ProgressStatusUpdate(ProgressStatus.SOURCE_FORMAT_COMPLETED));
        if (executionException1 != null) {
            throw executionException1;
        }
        if (!(this._sourceFormatterMessages.isEmpty() && this._sourceMismatchExceptions.isEmpty() || (string = this._sourceFormatterArgs.getOutputFileName()) == null)) {
            File directory;
            File file = null;
            int pos = string.lastIndexOf(File.separator);
            if (pos != -1 && (directory = new File(string.substring(0, pos))).exists()) {
                file = new File(string);
            }
            if (file == null) {
                file = new File(this._sourceFormatterArgs.getBaseDirName() + string);
            }
            FileUtil.write(file, this._getOutputFileContent());
        }
        if (this._sourceFormatterArgs.isFailOnAutoFix() && !this._sourceMismatchExceptions.isEmpty() || this._sourceFormatterArgs.isFailOnHasWarning() && !this._sourceFormatterMessages.isEmpty()) {
            throw new Exception(this._getExceptionMessage());
        }
    }

    public List<String> getModifiedFileNames() {
        return this._modifiedFileNames;
    }

    public SourceFormatterArgs getSourceFormatterArgs() {
        return this._sourceFormatterArgs;
    }

    public Set<SourceFormatterMessage> getSourceFormatterMessages() {
        return this._sourceFormatterMessages;
    }

    public List<SourceMismatchException> getSourceMismatchExceptions() {
        return this._sourceMismatchExceptions;
    }

    private static CheckstyleException _getNestedCheckstyleException(Exception exception) {
        Throwable throwable = exception;
        while (throwable != null) {
            if (throwable instanceof CheckstyleException) {
                return (CheckstyleException)throwable;
            }
            throwable = throwable.getCause();
        }
        return null;
    }

    private Set<String> _addDependentFileName(Set<String> dependentFileNames, String fileName) {
        File file = new File(this._sourceFormatterArgs.getBaseDirName() + fileName);
        if (file.exists()) {
            dependentFileNames.add(this._sourceFormatterArgs.getBaseDirName() + fileName);
        }
        return dependentFileNames;
    }

    private Set<String> _addDependentFileName(Set<String> dependentFileNames, String fileName, String dependentFileName) {
        String dirName = fileName.substring(0, fileName.lastIndexOf(47));
        while (true) {
            String dependentFilePathName;
            File file;
            if ((file = new File(dependentFilePathName = dirName + "/" + dependentFileName)).exists()) {
                dependentFileNames.add(dependentFilePathName);
                return dependentFileNames;
            }
            int pos = dirName.lastIndexOf(47);
            if (pos == -1) {
                return dependentFileNames;
            }
            dirName = dirName.substring(0, pos);
        }
    }

    private void _addDependentFileNames() throws Exception {
        Set<String> recentChangesFileNames = this._sourceFormatterArgs.getRecentChangesFileNames();
        if (recentChangesFileNames == null) {
            return;
        }
        Set<String> dependentFileNames = new HashSet<String>();
        boolean buildPropertiesAdded = false;
        boolean tagJavaFilesAdded = false;
        for (String recentChangesFileName : recentChangesFileNames) {
            if (!buildPropertiesAdded && recentChangesFileName.endsWith(".lfrbuild-portal")) {
                dependentFileNames = this._addDependentFileName(dependentFileNames, "build.properties");
                buildPropertiesAdded = true;
            }
            if (recentChangesFileName.contains("/modules/apps/archived/")) {
                dependentFileNames.addAll(SourceFormatterUtil.filterFileNames(this._allFileNames, new String[0], new String[]{"**/source-formatter.properties", "**/test.properties"}, this._sourceFormatterExcludes, false));
            }
            if (recentChangesFileName.endsWith(".java") && recentChangesFileName.contains("/upgrade/")) {
                dependentFileNames = this._addDependentFileName(dependentFileNames, recentChangesFileName, "bnd.bnd");
                continue;
            }
            if (recentChangesFileName.endsWith("ServiceImpl.java")) {
                dependentFileNames = this._addDependentFileName(dependentFileNames, recentChangesFileName, "service.xml");
                continue;
            }
            if (!tagJavaFilesAdded && recentChangesFileName.endsWith(".tld")) {
                dependentFileNames.addAll(SourceFormatterUtil.filterFileNames(this._allFileNames, new String[0], new String[]{"**/*Tag.java"}, this._sourceFormatterExcludes, false));
                tagJavaFilesAdded = true;
                continue;
            }
            if (recentChangesFileName.endsWith("/modules/source-formatter.properties")) {
                dependentFileNames.addAll(SourceFormatterUtil.filterFileNames(this._allFileNames, new String[0], new String[]{"**/build.gradle"}, this._sourceFormatterExcludes, false));
                continue;
            }
            if (!recentChangesFileName.endsWith(this._sourceFormatterArgs.getBaseDirName() + "release.properties")) continue;
            dependentFileNames.add(this._sourceFormatterArgs.getBaseDirName() + "/modules/sdk/ant-bnd/src/main/java/com/liferay/ant/bnd/social/SocialAnalyzerPlugin.java");
            dependentFileNames.add(this._sourceFormatterArgs.getBaseDirName() + "/portal-impl/src/com/liferay/portal/util/EntityResolver.java");
            dependentFileNames.add(this._sourceFormatterArgs.getBaseDirName() + "/portal-impl/src/com/liferay/portlet/social/util/SocialConfigurationImpl.java");
        }
        if (this._sourceFormatterArgs.isFormatCurrentBranch()) {
            List<String> deletedFileNames;
            if (!buildPropertiesAdded) {
                List<String> fileNames = GitUtil.getCurrentBranchFileNames(this._sourceFormatterArgs.getBaseDirName(), this._sourceFormatterArgs.getGitWorkingBranchName(), true);
                for (String fileName : fileNames) {
                    if (buildPropertiesAdded || !fileName.endsWith(".lfrbuild-portal")) continue;
                    dependentFileNames = this._addDependentFileName(dependentFileNames, "build.properties");
                    break;
                }
            }
            if (!(deletedFileNames = GitUtil.getCurrentBranchDeletedFileNames(this._sourceFormatterArgs.getBaseDirName(), this._sourceFormatterArgs.getGitWorkingBranchName())).isEmpty()) {
                dependentFileNames.addAll(SourceFormatterUtil.filterFileNames(this._allFileNames, new String[0], new String[]{"**/source-formatter.properties", "**/source-formatter-suppressions.xml"}, this._sourceFormatterExcludes, false));
            }
        }
        this._sourceFormatterArgs.addRecentChangesFileNames(dependentFileNames, null);
    }

    private boolean _containsDir(String dirName) {
        File directory = SourceFormatterUtil.getFile(this._sourceFormatterArgs.getBaseDirName(), dirName, this._sourceFormatterArgs.getMaxDirLevel());
        return directory != null;
    }

    private void _excludeWorkingDirCheckoutPrivateApps(File portalDir) throws Exception {
        File file = new File(portalDir, "working.dir.properties");
        if (!file.exists()) {
            return;
        }
        Properties properties = this._getProperties(file);
        for (Object key : properties.keySet()) {
            String s = (String)key;
            if (!s.matches("working.dir.checkout.private.apps.(\\w)+.dirs")) continue;
            List<String> dirs = ListUtil.fromString(properties.getProperty(s), ",");
            for (String dir : dirs) {
                this._sourceFormatterExcludes.addDefaultExcludeSyntaxPatterns(this._getExcludeSyntaxPatterns("**/" + dir + "/**"));
            }
        }
    }

    private List<String> _getCheckNames() {
        ArrayList<String> checkNames = new ArrayList<String>();
        for (String sourceProcessorName : this._sourceFormatterConfiguration.getSourceProcessorNames()) {
            for (SourceCheckConfiguration sourceCheckConfiguration : this._sourceFormatterConfiguration.getSourceCheckConfigurations(sourceProcessorName)) {
                checkNames.add(sourceCheckConfiguration.getName());
            }
        }
        return checkNames;
    }

    private String _getExceptionMessage() {
        int size = this._sourceFormatterMessages.size() + this._sourceMismatchExceptions.size();
        StringBundler sb = new StringBundler(size * 4);
        int index = 1;
        if (this._sourceFormatterArgs.isFailOnHasWarning()) {
            for (SourceFormatterMessage sourceFormatterMessage : this._sourceFormatterMessages) {
                sb.append(index);
                sb.append(": ");
                sb.append(sourceFormatterMessage.toString());
                sb.append("\n");
                ++index;
            }
        }
        if (this._sourceFormatterArgs.isFailOnAutoFix()) {
            for (SourceMismatchException sourceMismatchException : this._sourceMismatchExceptions) {
                String message = sourceMismatchException.getMessage();
                if (Objects.isNull(message)) continue;
                sb.append(index);
                sb.append(": ");
                sb.append(message);
                sb.append("\n");
                ++index;
            }
        }
        return StringBundler.concat("Found ", index - 1, " formatting issues:\n", sb.toString());
    }

    private List<ExcludeSyntaxPattern> _getExcludeSyntaxPatterns(String sourceFormatterExcludes) {
        ArrayList<ExcludeSyntaxPattern> excludeSyntaxPatterns = new ArrayList<ExcludeSyntaxPattern>();
        List<String> excludes = ListUtil.fromString(sourceFormatterExcludes, ",");
        for (String exclude : excludes) {
            excludeSyntaxPatterns.add(new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, exclude));
        }
        String systemExcludes = System.getProperty("source.formatter.excludes");
        excludes = ListUtil.fromString(GetterUtil.getString(systemExcludes));
        for (String exclude : excludes) {
            excludeSyntaxPatterns.add(new ExcludeSyntaxPattern(ExcludeSyntax.GLOB, exclude));
        }
        return excludeSyntaxPatterns;
    }

    private String _getOutputFileContent() {
        JSONObjectImpl jsonObject = new JSONObjectImpl();
        JSONArrayImpl modifiedFilesJSONArray = new JSONArrayImpl();
        for (SourceMismatchException sourceMismatchException : this._sourceMismatchExceptions) {
            modifiedFilesJSONArray.put(sourceMismatchException.getFileName());
        }
        jsonObject.put("modifiedFileNames", modifiedFilesJSONArray);
        JSONArrayImpl checksJSONArray = new JSONArrayImpl();
        JSONObject checkJSONObject = null;
        String currentCheckName = null;
        JSONArrayImpl violationsJSONArray = null;
        TreeSet<SourceFormatterMessage> sortedSourceFormatterMessages = new TreeSet<SourceFormatterMessage>(new SourceFormatterMessageCheckNameComparator());
        sortedSourceFormatterMessages.addAll(this._sourceFormatterMessages);
        int violationsCount = 0;
        for (SourceFormatterMessage sourceFormatterMessage : sortedSourceFormatterMessages) {
            String checkName = sourceFormatterMessage.getCheckName();
            if (checkName == null) continue;
            if (!Objects.equals(checkName, currentCheckName)) {
                if (currentCheckName != null) {
                    checkJSONObject.put("violations", violationsJSONArray);
                    checksJSONArray.put(checkJSONObject);
                }
                checkJSONObject = new JSONObjectImpl();
                checkJSONObject.put("name", checkName);
                String documentationURLString = sourceFormatterMessage.getDocumentationURLString();
                if (documentationURLString != null) {
                    checkJSONObject.put("documentationURLString", sourceFormatterMessage.getDocumentationURLString());
                }
                violationsJSONArray = new JSONArrayImpl();
                currentCheckName = checkName;
            }
            JSONObjectImpl violationJSONObject = new JSONObjectImpl();
            violationJSONObject.put("fileName", sourceFormatterMessage.getFileName()).put("lineNumber", sourceFormatterMessage.getLineNumber()).put("message", sourceFormatterMessage.getMessage());
            ++violationsCount;
            violationsJSONArray.put(violationJSONObject);
        }
        if (checkJSONObject != null) {
            checkJSONObject.put("violations", violationsJSONArray);
            checksJSONArray.put(checkJSONObject);
            jsonObject.put("checks", checksJSONArray);
        }
        jsonObject.put("violationsCount", violationsCount);
        return JSONUtil.toString(jsonObject);
    }

    private List<String> _getPluginsInsideModulesDirectoryNames() {
        ArrayList<String> pluginsInsideModulesDirectoryNames = new ArrayList<String>();
        List<String> pluginBuildFileNames = SourceFormatterUtil.filterFileNames(this._allFileNames, new String[0], new String[]{"**/modules/apps/**/build.xml", "**/modules/dxp/apps/**/build.xml", "**/modules/private/apps/**/build.xml"}, this._sourceFormatterExcludes, true);
        for (String pluginBuildFileName : pluginBuildFileNames) {
            String absolutePath = SourceUtil.getAbsolutePath(pluginBuildFileName = StringUtil.replace(pluginBuildFileName, '\\', '/'));
            int x = absolutePath.indexOf("/modules/apps/");
            if (x == -1) {
                x = absolutePath.indexOf("/modules/dxp/apps/");
            }
            if (x == -1) {
                x = absolutePath.indexOf("/modules/private/apps/");
            }
            int y = absolutePath.lastIndexOf("/");
            pluginsInsideModulesDirectoryNames.add(absolutePath.substring(x, y + 1));
        }
        return pluginsInsideModulesDirectoryNames;
    }

    private String _getPortalBranchName() {
        for (Map.Entry<String, Properties> entry : this._propertiesMap.entrySet()) {
            Properties properties = entry.getValue();
            if (!properties.containsKey("git.liferay.portal.branch")) continue;
            return properties.getProperty("git.liferay.portal.branch");
        }
        return null;
    }

    private String _getProjectPathPrefix() throws Exception {
        if (!this._subrepository) {
            return null;
        }
        String fileName = "gradle.properties";
        for (int i = 0; i < this._sourceFormatterArgs.getMaxDirLevel(); ++i) {
            File file = new File(this._sourceFormatterArgs.getBaseDirName() + fileName);
            if (file.exists()) {
                Properties properties = new Properties();
                properties.load(new FileInputStream(file));
                if (properties.containsKey("project.path.prefix")) {
                    return properties.getProperty("project.path.prefix");
                }
            }
            fileName = "../" + fileName;
        }
        return null;
    }

    private Properties _getProperties(File file) throws Exception {
        Properties properties = new Properties();
        if (file.exists()) {
            properties.load(new FileInputStream(file));
        }
        return properties;
    }

    private List<String> _getPropertyValues(String key) {
        ArrayList<String> propertyValues = new ArrayList<String>();
        for (Map.Entry<String, Properties> entry : this._propertiesMap.entrySet()) {
            Properties properties = entry.getValue();
            if (!properties.containsKey(key)) continue;
            propertyValues.addAll(ListUtil.fromString(properties.getProperty(key), ","));
        }
        return propertyValues;
    }

    private void _init() throws Exception {
        this._sourceFormatterExcludes = new SourceFormatterExcludes(SetUtil.fromArray(DEFAULT_EXCLUDE_SYNTAX_PATTERNS));
        this._portalSource = this._containsDir("portal-impl");
        if (this._portalSource) {
            File portalDir = SourceFormatterUtil.getPortalDir(this._sourceFormatterArgs.getBaseDirName(), this._sourceFormatterArgs.getMaxLineLength());
            this._excludeWorkingDirCheckoutPrivateApps(portalDir);
        }
        this._propertiesMap = new HashMap<String, Properties>();
        String parentDirName = this._sourceFormatterArgs.getBaseDirName();
        for (int i = 0; i < this._sourceFormatterArgs.getMaxDirLevel(); ++i) {
            this._readProperties(new File(parentDirName + _PROPERTIES_FILE_NAME));
            parentDirName = parentDirName + "../";
        }
        this._allFileNames = SourceFormatterUtil.scanForFiles(this._sourceFormatterArgs.getBaseDirName(), new String[0], new String[]{"**/*.*", "**/CODEOWNERS", "**/Dockerfile", "**/packageinfo"}, this._sourceFormatterExcludes, this._sourceFormatterArgs.isIncludeSubrepositories());
        List<String> modulePropertiesFileNames = SourceFormatterUtil.filterFileNames(this._allFileNames, new String[0], new String[]{"**/source-formatter.properties"}, this._sourceFormatterExcludes, true);
        for (String modulePropertiesFileName : modulePropertiesFileNames) {
            this._readProperties(new File(modulePropertiesFileName));
        }
        for (Properties properties : this._propertiesMap.values()) {
            if (!GetterUtil.getBoolean(properties.get("liferay.source"))) continue;
            this._portalSource = true;
            break;
        }
        if (!this._portalSource && this._containsDir("modules/private/apps")) {
            String propertiesContent = SourceFormatterUtil.getGitContent(_PROPERTIES_FILE_NAME, this._getPortalBranchName());
            this._readProperties(propertiesContent, SourceUtil.getAbsolutePath(this._sourceFormatterArgs.getBaseDirName()));
        }
        for (String sourceFormatterProperty : this._sourceFormatterArgs.getSourceFormatterProperties()) {
            this._readProperties(sourceFormatterProperty, SourceUtil.getAbsolutePath(this._sourceFormatterArgs.getBaseDirName()));
        }
        this._addDependentFileNames();
        this._pluginsInsideModulesDirectoryNames = this._getPluginsInsideModulesDirectoryNames();
        this._subrepository = this._isSubrepository();
        this._projectPathPrefix = this._getProjectPathPrefix();
        List<File> suppressionsFiles = SourceFormatterUtil.getSuppressionsFiles(this._sourceFormatterArgs.getBaseDirName(), this._allFileNames, this._sourceFormatterExcludes, this._sourceFormatterArgs.getMaxDirLevel());
        this._sourceFormatterSuppressions = SuppressionsLoader.loadSuppressions(this._sourceFormatterArgs.getBaseDirName(), suppressionsFiles, this._propertiesMap);
        this._sourceFormatterConfiguration = ConfigurationLoader.loadConfiguration("sourcechecks.xml");
        if (this._sourceFormatterArgs.isShowDebugInformation()) {
            DebugUtil.addCheckNames(CheckType.SOURCE_CHECK, this._getCheckNames());
        }
    }

    private boolean _isSubrepository() throws Exception {
        if (this._portalSource) {
            return false;
        }
        String baseDirAbsolutePath = SourceUtil.getAbsolutePath(this._sourceFormatterArgs.getBaseDirName());
        File baseDir = new File(baseDirAbsolutePath);
        for (int i = 0; i < 3; ++i) {
            String content;
            if (baseDir == null || !baseDir.exists()) {
                return false;
            }
            File gradlePropertiesFile = new File(baseDir, "gradle.properties");
            File gradlewFile = new File(baseDir, "gradlew");
            if (gradlePropertiesFile.exists() && gradlewFile.exists() && (content = FileUtil.read(gradlePropertiesFile)).contains("project.path.prefix=")) {
                return true;
            }
            baseDir = baseDir.getParentFile();
        }
        return false;
    }

    private void _printProgressStatusMessage(String message) {
        if (!this._sourceFormatterArgs.isShowStatusUpdates()) {
            return;
        }
        if (message.length() > this._maxStatusMessageLength) {
            this._maxStatusMessageLength = message.length();
        }
        System.out.print(message + "\r");
    }

    private void _readProperties(File propertiesFile) throws Exception {
        Properties properties = this._getProperties(propertiesFile);
        if (properties.isEmpty()) {
            return;
        }
        String propertiesFileLocation = SourceUtil.getAbsolutePath(propertiesFile);
        int pos = propertiesFileLocation.lastIndexOf("/");
        propertiesFileLocation = propertiesFileLocation.substring(0, pos);
        this._readProperties(properties, propertiesFileLocation);
    }

    private void _readProperties(Properties properties, String propertiesFileLocation) {
        Properties existingProperties;
        String value = properties.getProperty("source.formatter.excludes");
        if (value != null) {
            if (FileUtil.exists(propertiesFileLocation + "portal-impl")) {
                this._sourceFormatterExcludes.addDefaultExcludeSyntaxPatterns(this._getExcludeSyntaxPatterns(value));
            } else {
                this._sourceFormatterExcludes.addExcludeSyntaxPatterns(propertiesFileLocation, this._getExcludeSyntaxPatterns(value));
            }
            properties.remove("source.formatter.excludes");
        }
        if ((existingProperties = this._propertiesMap.get(propertiesFileLocation)) == null) {
            this._propertiesMap.put(propertiesFileLocation, properties);
        } else {
            existingProperties.putAll((Map<?, ?>)properties);
            this._propertiesMap.put(propertiesFileLocation, existingProperties);
        }
    }

    private void _readProperties(String content, String propertiesFileLocation) throws Exception {
        Properties properties = new Properties();
        properties.load(new StringReader(content));
        if (properties.isEmpty()) {
            return;
        }
        this._readProperties(properties, propertiesFileLocation);
    }

    private void _runSourceProcessor(SourceProcessor sourceProcessor) throws Exception {
        sourceProcessor.setAllFileNames(this._allFileNames);
        sourceProcessor.setPluginsInsideModulesDirectoryNames(this._pluginsInsideModulesDirectoryNames);
        sourceProcessor.setPortalSource(this._portalSource);
        sourceProcessor.setProgressStatusQueue(this._progressStatusQueue);
        sourceProcessor.setProjectPathPrefix(this._projectPathPrefix);
        sourceProcessor.setPropertiesMap(this._propertiesMap);
        sourceProcessor.setSourceFormatterArgs(this._sourceFormatterArgs);
        sourceProcessor.setSourceFormatterConfiguration(this._sourceFormatterConfiguration);
        sourceProcessor.setSourceFormatterExcludes(this._sourceFormatterExcludes);
        sourceProcessor.setSourceFormatterSuppressions(this._sourceFormatterSuppressions);
        sourceProcessor.setSubrepository(this._subrepository);
        sourceProcessor.format();
        this._sourceFormatterMessages.addAll(sourceProcessor.getSourceFormatterMessages());
        this._sourceMismatchExceptions.addAll(sourceProcessor.getSourceMismatchExceptions());
        this._modifiedFileNames.addAll(sourceProcessor.getModifiedFileNames());
    }

    private void _validateCommitMessages() throws Exception {
        List<String> commitMessages = GitUtil.getCurrentBranchCommitMessages(this._sourceFormatterArgs.getBaseDirName(), this._sourceFormatterArgs.getGitWorkingBranchName());
        JIRAUtil.validateJIRAProjectNames(commitMessages, this._getPropertyValues("jira.project.keys"));
        JIRAUtil.validateJIRATicketIds(commitMessages, 20);
        JIRAUtil.validateJIRASecurityKeywords(commitMessages, this._getPropertyValues("jira.security.vulnerability.keywords"), 20);
    }

    private static class SourceFormatterMessageCheckNameComparator
    implements Comparator<SourceFormatterMessage> {
        private SourceFormatterMessageCheckNameComparator() {
        }

        @Override
        public int compare(SourceFormatterMessage sourceFormatterMessage1, SourceFormatterMessage sourceFormatterMessage2) {
            String checkName1 = sourceFormatterMessage1.getCheckName();
            String checkName2 = sourceFormatterMessage2.getCheckName();
            if (checkName1 != null && checkName2 != null && !checkName1.equals(checkName2)) {
                return checkName1.compareTo(checkName2);
            }
            return sourceFormatterMessage1.compareTo(sourceFormatterMessage2);
        }
    }
}

