/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.util;

import com.liferay.poshi.core.util.ListUtil;
import com.liferay.poshi.core.util.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class PropsUtil {
    private static final PropsUtil _propsUtil = new PropsUtil();
    private final Properties _props = new Properties();

    public static void clear() {
        PropsUtil._propsUtil._props.clear();
        PropsUtil.setProperties(PropsUtil._getClassProperties());
    }

    public static String get(String key) {
        return _propsUtil._get(key);
    }

    public static Properties getProperties() {
        return PropsUtil._propsUtil._props;
    }

    public static void set(String key, String value) {
        _propsUtil._set(key, value);
    }

    public static void setProperties(Properties properties) {
        for (String propertyName : properties.stringPropertyNames()) {
            String propertyValue = properties.getProperty(propertyName);
            if (propertyValue == null) continue;
            PropsUtil.set(propertyName, propertyValue);
        }
    }

    private static Properties _getClassProperties() {
        String[] propertiesFileNames;
        Properties classProperties = new Properties();
        for (String propertiesFileName : propertiesFileNames = new String[]{"poshi.properties", "poshi-ext.properties"}) {
            Class<PropsUtil> clazz = PropsUtil.class;
            ClassLoader classLoader = clazz.getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream(propertiesFileName);
            if (inputStream == null) continue;
            try {
                classProperties.load(inputStream);
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
        }
        return classProperties;
    }

    private PropsUtil() {
        Properties properties = PropsUtil._getClassProperties();
        for (String propertyName : properties.stringPropertyNames()) {
            this._props.setProperty(propertyName, properties.getProperty(propertyName));
        }
        this._printProperties(false);
    }

    private String _get(String key) {
        String value = System.getProperty(key);
        if (Validator.isNull(value)) {
            value = this._props.getProperty(key);
        }
        return value;
    }

    private void _printProperties(boolean update) {
        List<?> keys = Collections.list(this._props.propertyNames());
        keys = ListUtil.sort(keys);
        if (update) {
            System.out.println("-- updated properties --");
        } else {
            System.out.println("-- listing properties --");
        }
        for (String key : keys) {
            System.out.println(key + "=" + this._get(key));
        }
        System.out.println("");
    }

    private void _set(String key, String value) {
        this._props.setProperty(key, value);
    }
}

