/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.petra.string.CharPool;
import com.liferay.portal.kernel.util.StringUtil;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;

import java.util.regex.Pattern;

/**
 * @author Alan Huang
 */
public class DTOEnumCreationCheck extends BaseCheck {

	@Override
	public int[] getDefaultTokens() {
		return new int[] {TokenTypes.METHOD_CALL};
	}

	@Override
	protected void doVisitToken(DetailAST detailAST) {
		DetailAST firstChildDetailAST = detailAST.getFirstChild();

		if (firstChildDetailAST.getType() != TokenTypes.DOT) {
			return;
		}

		FullIdent fullIdent = FullIdent.createFullIdent(firstChildDetailAST);

		String fullyQualifiedName = fullIdent.getText();

		if (StringUtil.count(fullyQualifiedName, CharPool.PERIOD) != 2) {
			return;
		}

		String fullyQualifiedTypeName = getFullyQualifiedTypeName(
			fullyQualifiedName, firstChildDetailAST, true);

		if (Pattern.matches(
				"com\\.liferay(\\.\\w+)+\\.v\\d+_\\d+(\\.\\w+){2}\\.valueOf",
				fullyQualifiedTypeName)) {

			log(detailAST, _MSG_USE_CREATE);
		}
	}

	private static final String _MSG_USE_CREATE = "create.use";

}