/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringUtil;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;

/**
 * @author Hugo Huijser
 */
public class ContractionsCheck extends BaseCheck {

	@Override
	public int[] getDefaultTokens() {
		return new int[] {TokenTypes.STRING_LITERAL};
	}

	@Override
	protected void doVisitToken(DetailAST detailAST) {
		String s = StringUtil.toLowerCase(detailAST.getText());

		for (String contraction : _CONTRACTIONS) {
			int i = s.indexOf(StringUtil.toLowerCase(contraction));

			if ((i != -1) && !Character.isLetterOrDigit(s.charAt(i - 1)) &&
				!Character.isLetterOrDigit(
					s.charAt(i + contraction.length()))) {

				log(detailAST, _MSG_AVOID_CONTRACTION, contraction);
			}
		}
	}

	private static final String[] _CONTRACTIONS = {
		"aren't", "can't", "could've", "couldn't", "didn't", "doesn't", "don't",
		"hadn't", "hasn't", "haven't", "how's", "I'd", "I'll", "I've", "isn't",
		"it's", "let's", "shouldn't", "that's", "there's", "wasn't", "we'd",
		"we'll", "we're", "we've", "weren't", "what's", "where's", "would've",
		"wouldn't", "you'd", "you'll", "you're", "you've"
	};

	private static final String _MSG_AVOID_CONTRACTION = "contraction.avoid";

}