/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;

import java.util.List;

/**
 * @author Peter Shin
 */
public class ConstructorMissingEmptyLineCheck extends BaseCheck {

	@Override
	public int[] getDefaultTokens() {
		return new int[] {TokenTypes.CTOR_DEF};
	}

	@Override
	protected void doVisitToken(DetailAST detailAST) {
		DetailAST statementsDetailAST = detailAST.findFirstToken(
			TokenTypes.SLIST);

		if (statementsDetailAST == null) {
			return;
		}

		List<String> parameterNames = getParameterNames(detailAST);

		if (parameterNames.isEmpty()) {
			return;
		}

		DetailAST nextExpressionDetailAST = statementsDetailAST.getFirstChild();

		if (!_isExpressionAssignsParameter(
				nextExpressionDetailAST, parameterNames)) {

			return;
		}

		int endLineNumber = getEndLineNumber(nextExpressionDetailAST);

		while (true) {
			nextExpressionDetailAST = nextExpressionDetailAST.getNextSibling();

			nextExpressionDetailAST = nextExpressionDetailAST.getNextSibling();

			if ((nextExpressionDetailAST != null) &&
				(nextExpressionDetailAST.getType() == TokenTypes.RCURLY)) {

				return;
			}

			if (!_isExpressionAssignsParameter(
					nextExpressionDetailAST, parameterNames)) {

				int startLineNumber = getStartLineNumber(
					nextExpressionDetailAST);

				if ((endLineNumber + 1) != startLineNumber) {
					return;
				}

				log(startLineNumber, _MSG_MISSING_EMPTY_LINE, startLineNumber);

				return;
			}

			endLineNumber = getEndLineNumber(nextExpressionDetailAST);
		}
	}

	private boolean _isExpressionAssignsParameter(
		DetailAST expressionDetailAST, List<String> parameters) {

		if ((expressionDetailAST == null) ||
			(expressionDetailAST.getType() != TokenTypes.EXPR)) {

			return false;
		}

		DetailAST childDetailAST = expressionDetailAST.getFirstChild();

		if ((childDetailAST.getType() != TokenTypes.ASSIGN) ||
			(childDetailAST.getChildCount() != 2)) {

			return false;
		}

		DetailAST firstChildDetailAST = childDetailAST.getFirstChild();

		if (firstChildDetailAST.getType() != TokenTypes.IDENT) {
			if (firstChildDetailAST.getChildCount() != 2) {
				return false;
			}

			DetailAST detailAST1 = firstChildDetailAST.getFirstChild();
			DetailAST detailAST2 = firstChildDetailAST.getLastChild();

			if ((detailAST1.getType() != TokenTypes.LITERAL_THIS) ||
				(detailAST2.getType() != TokenTypes.IDENT)) {

				return false;
			}
		}

		DetailAST lastChildDetailAST = childDetailAST.getLastChild();

		if (lastChildDetailAST.getType() == TokenTypes.IDENT) {
			String text = lastChildDetailAST.getText();

			if (!parameters.contains(text) && !text.matches("^[A-Z0-9_]+$")) {
				return false;
			}
		}

		DetailAST nextSiblingDetailAST = expressionDetailAST.getNextSibling();

		if (nextSiblingDetailAST.getType() != TokenTypes.SEMI) {
			return false;
		}

		return true;
	}

	private static final String _MSG_MISSING_EMPTY_LINE = "empty.line.missing";

}