/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;

import java.io.File;

import java.util.List;

/**
 * @author Hugo Huijser
 */
public class ArquillianCheck extends BaseCheck {

	@Override
	public int[] getDefaultTokens() {
		return new int[] {TokenTypes.PACKAGE_DEF};
	}

	@Override
	protected void doVisitToken(DetailAST detailAST) {
		String absolutePath = getAbsolutePath();

		int pos = absolutePath.indexOf("/testIntegration/");

		if (pos == -1) {
			return;
		}

		List<String> importNames = getImportNames(detailAST);

		if (!importNames.contains("org.jboss.arquillian.junit.Arquillian") ||
			importNames.contains(
				"org.jboss.arquillian.container.test.api.RunAsClient")) {

			return;
		}

		File xmlFile = new File(
			absolutePath.substring(0, pos) +
				"/testIntegration/resources/arquillian.xml");

		if (!xmlFile.exists()) {
			log(detailAST, _MSG_INVALID_IMPORT);
		}
	}

	private static final String _MSG_INVALID_IMPORT = "import.invalid";

}