/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checks;

/**
 * @author Alan Huang
 */
public class YMLStylingCheck extends BaseFileCheck {

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		content = content.replaceAll(
			"(\\A|\n)( *)(description:) (?!\\|-)(.+)(\\Z|\n)",
			"$1$2$3\n    $2$4$5");

		content = content.replaceAll("(\\A|\n) *description:\n +\"\"", "");

		content = content.replaceAll(
			"(\\A|\n)( *#)@? ?(review)(\\Z|\n)", "$1$2 @$3$4");

		content = content.replaceAll(
			"(\\A|\n)(( *)|(.+: ))'([^'\"]*)'(\\Z|\n)", "$1$2\"$5\"$6");

		content = content.replaceAll(
			"(\\A|\n)( *)'([^'\"]+)'(:.*)(\\Z|\n)", "$1$2\"$3\"$4$5");

		if (fileName.endsWith("/rest-config.yaml")) {
			content = content.replaceAll(
				"(\\A|\n)( *baseURI: ((['\"](?!/))|(?!['\"/])))(.*)",
				"$1$2/$5");
		}

		return content;
	}

}