/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.NaturalOrderStringComparator;

/**
 * @author Hugo Huijser
 */
public class PropertiesDefinitionKeysCheck extends BaseDefinitionKeysCheck {

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		if (fileName.endsWith("/liferay-plugin-package.properties") ||
			fileName.endsWith("/TLiferayBatchFileProperties.properties")) {

			content = sortDefinitionKeys(
				content, getDefinitions(content),
				new NaturalOrderStringComparator());
		}

		return content;
	}

}