/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.util.SourceFormatterUtil;

import java.io.FileNotFoundException;
import java.io.IOException;

import java.net.URL;

import java.util.List;

/**
 * @author Hugo Huijser
 */
public class NewFileCheck extends BaseFileCheck {

	@Override
	public boolean isLiferaySourceCheck() {
		return true;
	}

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		List<String> forbiddenDirNames = getAttributeValues(
			_FORBIDDEN_DIR_NAMES_KEY, absolutePath);

		if (forbiddenDirNames.isEmpty()) {
			return content;
		}

		String portalBranchName = getAttributeValue(
			SourceFormatterUtil.GIT_LIFERAY_PORTAL_BRANCH, absolutePath);

		for (String forbiddenDirName : forbiddenDirNames) {
			int pos = absolutePath.indexOf(forbiddenDirName);

			if (pos == -1) {
				continue;
			}

			try {
				URL url = SourceFormatterUtil.getPortalGitURL(
					absolutePath.substring(pos), portalBranchName);

				url.openStream();
			}
			catch (FileNotFoundException fileNotFoundException) {
				addMessage(
					fileName,
					"Do not add new files to '" + forbiddenDirName + "'");
			}
			catch (IOException ioException) {
			}
		}

		return content;
	}

	private static final String _FORBIDDEN_DIR_NAMES_KEY = "forbiddenDirNames";

}