/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.util.StringUtil;

import java.util.List;

/**
 * @author Peter Shin
 */
public class LFRBuildContentCheck extends BaseFileCheck {

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		if (_isNonemptyMarkerFileName(absolutePath)) {
			content = StringUtil.trim(content);
		}
		else {
			content = StringPool.BLANK;
		}

		return content;
	}

	private boolean _isNonemptyMarkerFileName(String absolutePath) {
		List<String> nonemptyMarkerFileNames = getAttributeValues(
			_NONEMPTY_MARKER_FILE_NAMES_KEY, absolutePath);

		for (String nonemptyMarkerFileName : nonemptyMarkerFileNames) {
			if (absolutePath.endsWith(nonemptyMarkerFileName)) {
				return true;
			}
		}

		return false;
	}

	private static final String _NONEMPTY_MARKER_FILE_NAMES_KEY =
		"nonemptyMarkerFileNames";

}