/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checks;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author Hugo Huijser
 */
public class JavaResultSetCheck extends BaseFileCheck {

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		Matcher matcher = _tryStatementPattern.matcher(content);

		while (matcher.find()) {
			int x = content.indexOf("\"select count(", matcher.start());

			if (x == -1) {
				continue;
			}

			int y = content.indexOf("resultSet.getLong(1)", matcher.start());
			int z = content.indexOf(
				"\n" + matcher.group(1) + "}", matcher.start());

			if ((y != -1) && (z != -1) && (x < y) && (y < z)) {
				addMessage(
					fileName, "Use resultSet.getInt(1) for count",
					getLineNumber(content, y));
			}
		}

		return content;
	}

	private static final Pattern _tryStatementPattern = Pattern.compile(
		"\n(\t+)try [\\{\\(]");

}