/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checks;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

import java.util.Properties;

/**
 * @author Alan Huang
 */
public class JavaMissingXMLPublicIdsCheck extends BaseFileCheck {

	@Override
	public boolean isLiferaySourceCheck() {
		return true;
	}

	@Override
	protected String doProcess(
			String fileName, String absolutePath, String content)
		throws IOException {

		if (!fileName.endsWith(
				"/modules/sdk/ant-bnd/src/main/java/com/liferay/ant/bnd" +
					"/social/SocialAnalyzerPlugin.java") &&
			!fileName.endsWith(
				"/portal-impl/src/com/liferay/portal/util" +
					"/EntityResolver.java") &&
			!fileName.endsWith(
				"/portal-impl/src/com/liferay/portlet/social/util" +
					"/SocialConfigurationImpl.java")) {

			return content;
		}

		File releasePropertiesFile = new File(
			getPortalDir(), _RELEASE_PROPERTIES_FILE_NAME);

		if (!releasePropertiesFile.exists()) {
			return content;
		}

		Properties properties = new Properties();

		properties.load(new FileInputStream(releasePropertiesFile));

		String lpVersion = properties.getProperty("lp.version");

		if (lpVersion == null) {
			return content;
		}

		if (content.indexOf(lpVersion + "//EN") == -1) {
			addMessage(
				fileName,
				"Missing public id '" + lpVersion + "' for check XML files");
		}

		return content;
	}

	private static final String _RELEASE_PROPERTIES_FILE_NAME =
		"release.properties";

}