/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checks;

import com.liferay.portal.tools.ToolsUtil;

/**
 * @author Preston Crary
 */
public class JavaCollatorUtilCheck extends BaseFileCheck {

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		if (!fileName.endsWith("CollatorUtil.java") &&
			!fileName.endsWith("CollatorUtilTest.java")) {

			_checkCollatorGetInstance(fileName, content);
		}

		return content;
	}

	private void _checkCollatorGetInstance(String fileName, String content) {
		int index = content.indexOf("Collator.getInstance(");

		while (index != -1) {
			if (!ToolsUtil.isInsideQuotes(content, index)) {
				addMessage(
					fileName, "Use CollatorUtil.getInstance(Locale)",
					getLineNumber(content, index));
			}

			index = content.indexOf("Collator.getInstance(", index + 1);
		}
	}

}