/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checks;

import com.liferay.petra.string.CharPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;

import java.util.List;

/**
 * @author Hugo Huijser
 */
public class JavaBooleanUsageCheck extends BaseFileCheck {

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		return _fixIncorrectBooleanUse(content, "setAttribute");
	}

	private String _fixIncorrectBooleanUse(String content, String methodName) {
		int x = -1;

		while (true) {
			x = content.indexOf("." + methodName + "(", x + 1);

			if (x == -1) {
				return content;
			}

			if (ToolsUtil.isInsideQuotes(content, x)) {
				continue;
			}

			String methodCall = null;

			int y = x;

			while (true) {
				y = content.indexOf(")", y + 1);

				if (y == -1) {
					return content;
				}

				methodCall = content.substring(x, y + 1);

				if (!ToolsUtil.isInsideQuotes(content, y) &&
					(getLevel(methodCall) == 0)) {

					break;
				}
			}

			if (methodCall.contains("\t//") ||
				(content.charAt(y + 1) != CharPool.SEMICOLON)) {

				continue;
			}

			List<String> parameterList = JavaSourceUtil.getParameterList(
				methodCall);

			if (parameterList.size() != 2) {
				continue;
			}

			String secondParameterName = parameterList.get(1);

			if (secondParameterName.equals("false") ||
				secondParameterName.equals("true")) {

				String replacement = StringUtil.replaceLast(
					methodCall, secondParameterName,
					"Boolean." + StringUtil.toUpperCase(secondParameterName));

				return StringUtil.replace(content, methodCall, replacement);
			}
		}
	}

}