/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author Hugo Huijser
 */
public class JSPVarNameCheck extends BaseFileCheck {

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		Matcher matcher = _varNamePattern.matcher(content);

		while (matcher.find()) {
			String varName = matcher.group(1);

			String expectedVarName = null;

			if (varName.matches(".*[a-z]Url")) {
				expectedVarName = StringUtil.replaceLast(varName, "Url", "URL");
			}
			else if (varName.matches(".*[a-z]Html")) {
				expectedVarName = StringUtil.replaceLast(
					varName, "Html", "HTML");
			}

			if (expectedVarName != null) {
				addMessage(
					fileName,
					StringBundler.concat(
						"Rename var '", varName, "' to '", expectedVarName,
						"'"),
					getLineNumber(content, matcher.start()));
			}
		}

		return content;
	}

	private static final Pattern _varNamePattern = Pattern.compile(
		"\\svar=\"(\\w+)\"");

}