/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checks;

/**
 * @author Hugo Huijser
 */
public class JSPModuleIllegalImportsCheck extends BaseFileCheck {

	@Override
	public boolean isModuleSourceCheck() {
		return true;
	}

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		if (content.contains("import=\"com.liferay.registry.Registry")) {
			addMessage(
				fileName,
				"Do not use com.liferay.registry.Registry in modules");
		}

		if (content.contains("import=\"com.liferay.util.ContentUtil")) {
			addMessage(
				fileName, "Do not use com.liferay.util.ContentUtil in modules");
		}

		return content;
	}

}