/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checks;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author Alan Huang
 */
public class JSPMethodCallsCheck extends BaseStylingCheck {

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		Matcher matcher = _incorrectMethodCallPattern.matcher(content);

		while (matcher.find()) {
			addMessage(
				fileName,
				"Use type 'LiferayPortletResponse' to call 'getNamespace()'",
				getLineNumber(content, matcher.start()));
		}

		return content;
	}

	private static final Pattern _incorrectMethodCallPattern = Pattern.compile(
		"(?<!\\bliferayPortlet)Response\\.getNamespace\\(\\)");

}