/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.java.parser.JavaParser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author Hugo Huijser
 */
public class JSPJavaParserCheck extends BaseFileCheck {

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		Matcher matcher = _javaSourcePattern.matcher(content);

		while (matcher.find()) {
			try {
				String indent = matcher.group(1);

				if (Validator.isNotNull(matcher.group(2))) {
					indent += "\t";
				}

				String match = matcher.group(3);

				String replacement = JavaParser.parseSnippet(match, indent);

				if (!match.equals(replacement)) {
					return StringUtil.replaceFirst(
						content, match, replacement, matcher.start());
				}
			}
			catch (Exception exception) {
				if (_log.isDebugEnabled()) {
					_log.debug(exception, exception);
				}
			}
		}

		return content;
	}

	private static final Log _log = LogFactoryUtil.getLog(
		JSPJavaParserCheck.class);

	private static final Pattern _javaSourcePattern = Pattern.compile(
		"\n(\t*)(.*)<%=?\n(((?!%>)[\\s\\S])*)\n\t*%>");

}