/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checks;

import com.liferay.petra.string.CharPool;
import com.liferay.petra.string.StringBundler;

/**
 * @author Hugo Huijser
 */
public class JSPFileNameCheck extends BaseFileCheck {

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		if (!fileName.endsWith(".jsp") && !fileName.endsWith(".jspf")) {
			return content;
		}

		int x = absolutePath.lastIndexOf(CharPool.SLASH);
		int y = absolutePath.lastIndexOf(CharPool.PERIOD);

		String shortFileName = absolutePath.substring(x + 1, y);

		if (shortFileName.endsWith("-compat") ||
			shortFileName.endsWith("-ext")) {

			return content;
		}

		for (char c : shortFileName.toCharArray()) {
			if (!Character.isLetterOrDigit(c) && (c != CharPool.UNDERLINE)) {
				addMessage(
					fileName,
					StringBundler.concat("Do not use '", c, "' in file name"));
			}
		}

		return content;
	}

}