/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.BNDSettings;
import com.liferay.source.formatter.util.FileUtil;

import java.io.IOException;

import org.json.JSONObject;

/**
 * @author Hugo Huijser
 */
public class JSONPackageJSONBNDVersionCheck extends BaseFileCheck {

	@Override
	public boolean isLiferaySourceCheck() {
		return true;
	}

	@Override
	protected String doProcess(
			String fileName, String absolutePath, String content)
		throws IOException {

		if (!absolutePath.endsWith("/package.json") ||
			(!absolutePath.contains("/modules/apps/") &&
			 !absolutePath.contains("/modules/dxp/apps/") &&
			 !absolutePath.contains("/modules/private/apps/"))) {

			return content;
		}

		JSONObject jsonObject = new JSONObject(content);

		if (jsonObject.isNull("version")) {
			return content;
		}

		int x = fileName.lastIndexOf(StringPool.SLASH);

		if (!FileUtil.exists(fileName.substring(0, x + 1) + "bnd.bnd")) {
			return content;
		}

		String version = jsonObject.getString("version");

		BNDSettings bndSettings = getBNDSettings(fileName);

		String bndReleaseVersion = bndSettings.getReleaseVersion();

		if (!version.equals(bndReleaseVersion)) {
			return StringUtil.replaceFirst(
				content, "\"version\": \"" + version + "\"",
				"\"version\": \"" + bndReleaseVersion + "\"");
		}

		return content;
	}

}