/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.util.SourceUtil;

import java.util.List;

/**
 * @author Alan Huang
 */
public class JSONDeprecatedPackagesCheck extends BaseFileCheck {

	@Override
	public boolean isLiferaySourceCheck() {
		return true;
	}

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		if (!absolutePath.endsWith("/package.json")) {
			return content;
		}

		List<String> deprecatedPackageNames = getAttributeValues(
			_DEPRECATED_PACKAGE_NAMES_KEY, absolutePath);

		for (String deprecatedPackageName : deprecatedPackageNames) {
			int x = -1;

			while (true) {
				x = content.indexOf(
					"\"" + deprecatedPackageName + "\":", x + 1);

				if (x == -1) {
					break;
				}

				addMessage(
					fileName,
					"Do not use deprecated package '" + deprecatedPackageName +
						"'",
					SourceUtil.getLineNumber(content, x));
			}
		}

		return content;
	}

	private static final String _DEPRECATED_PACKAGE_NAMES_KEY =
		"deprecatedPackageNames";

}