/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.parser.GradleFile;

/**
 * @author Peter Shin
 */
public class GradleTaskCreationCheck extends BaseGradleFileCheck {

	@Override
	protected String doProcess(
		String fileName, String absolutePath, GradleFile gradleFile,
		String content) {

		if (absolutePath.contains("/project-templates-")) {
			return content;
		}

		String[] lines = StringUtil.splitLines(content);

		for (String line : lines) {
			if (line.matches("^task\\s+.*$") && line.contains("{")) {
				addMessage(
					fileName,
					"The task should be declared in a separate line before " +
						"the closure",
					getLineNumber(content, content.indexOf(line)));
			}
		}

		return content;
	}

}