/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checks;

import com.liferay.petra.string.CharPool;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.IOException;

import java.util.Map;

/**
 * @author Peter Shin
 */
public class GradlePropertiesCheck extends BaseFileCheck {

	@Override
	protected String doProcess(
			String fileName, String absolutePath, String content)
		throws IOException {

		StringBundler sb = new StringBundler();

		try (UnsyncBufferedReader unsyncBufferedReader =
				new UnsyncBufferedReader(new UnsyncStringReader(content))) {

			String line = null;

			while ((line = unsyncBufferedReader.readLine()) != null) {
				sb.append(_fixValue(line));
				sb.append("\n");
			}
		}

		if (sb.length() > 0) {
			sb.setIndex(sb.index() - 1);
		}

		return sb.toString();
	}

	private final String _fixValue(String line) {
		String[] array = line.split(StringPool.EQUAL, 2);

		if (array.length != 2) {
			return line;
		}

		String regex = _keysRegexMap.get(StringUtil.trim(array[0]));

		if (regex == null) {
			return line;
		}

		String value = StringUtil.trim(array[1]);

		String strippedValue = StringUtil.removeChars(
			value, CharPool.APOSTROPHE, CharPool.QUOTE);

		if (strippedValue.matches(regex)) {
			return StringUtil.replaceLast(
				line, value, "\"" + strippedValue + "\"");
		}

		return line;
	}

	private static final Map<String, String> _keysRegexMap = MapUtil.fromArray(
		new String[] {
			"sourceCompatibility", "[0-9]+\\.[0-9]+", "targetCompatibility",
			"[0-9]+\\.[0-9]+"
		});

}