/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checks;

import com.liferay.petra.string.CharPool;
import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.util.StringUtil;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author Hugo Huijser
 */
public class CSSCommentsCheck extends BaseFileCheck {

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		return _formatComments(content);
	}

	private String _formatComments(String content) {
		Matcher commentMatcher = _commentPattern.matcher(content);

		while (commentMatcher.find()) {
			Matcher commentFormatMatcher = _commentFormatPattern.matcher(
				commentMatcher.group(1));

			if (!commentFormatMatcher.find()) {
				continue;
			}

			String comment = commentFormatMatcher.group(1);

			String[] words = StringUtil.split(comment, CharPool.SPACE);

			for (int i = 1; i < words.length; i++) {
				String previousWord = words[i - 1];

				if (previousWord.endsWith(StringPool.PERIOD) ||
					previousWord.equals(StringPool.SLASH)) {

					continue;
				}

				String word = words[i];

				if ((word.length() > 1) &&
					Character.isUpperCase(word.charAt(0)) &&
					StringUtil.isLowerCase(word.substring(1))) {

					comment = StringUtil.replaceFirst(
						comment, word, StringUtil.toLowerCase(word));
				}
			}

			content = StringUtil.replaceFirst(
				content, commentMatcher.group(),
				"/* ---------- " + comment + " ---------- */");
		}

		return content;
	}

	private static final Pattern _commentFormatPattern = Pattern.compile(
		"^-* ?(\\S[ \\w]*?\\S) ?-*$");
	private static final Pattern _commentPattern = Pattern.compile(
		"/\\*[\n ](.*)[\n ]\\*/");

}