/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.parser.GradleFile;

import java.io.IOException;

/**
 * @author Peter Shin
 */
public abstract class BaseGradleFileCheck
	extends BaseSourceCheck implements GradleFileCheck {

	@Override
	public String process(
			String fileName, String absolutePath, GradleFile gradleFile,
			String content)
		throws IOException {

		clearSourceFormatterMessages(fileName);

		return doProcess(fileName, absolutePath, gradleFile, content);
	}

	protected abstract String doProcess(
			String fileName, String absolutePath, GradleFile gradleFile,
			String fileContent)
		throws IOException;

}