/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.util.BNDSourceUtil;

import java.util.List;

/**
 * @author Alan Huang
 */
public class BNDLiferayRelengCategoryCheck extends BaseFileCheck {

	@Override
	public boolean isModuleSourceCheck() {
		return true;
	}

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		if (!absolutePath.endsWith("/app.bnd")) {
			return content;
		}

		String liferayRelengCategory = BNDSourceUtil.getDefinitionValue(
			content, "Liferay-Releng-Category");

		if (Validator.isNull(liferayRelengCategory)) {
			return content;
		}

		List<String> allowedLiferayRelengCategoryNames = getAttributeValues(
			_ALLOWED_LIFERAY_RELENG_CATEGORY_NAMES_KEY, absolutePath);

		if (!allowedLiferayRelengCategoryNames.isEmpty() &&
			!allowedLiferayRelengCategoryNames.contains(
				liferayRelengCategory)) {

			String message = StringBundler.concat(
				"The value for 'Liferay-Releng-Category' can be either blank ",
				"or one of the following values '",
				StringUtil.merge(allowedLiferayRelengCategoryNames, ", "), "'");

			addMessage(fileName, message);
		}

		return content;
	}

	private static final String _ALLOWED_LIFERAY_RELENG_CATEGORY_NAMES_KEY =
		"allowedLiferayRelengCategoryNames";

}