/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter;

import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.checks.util.XMLSourceUtil;

import java.io.File;
import java.io.IOException;

import java.util.List;

/**
 * @author Hugo Huijser
 */
public class XMLSourceProcessor extends BaseSourceProcessor {

	@Override
	protected List<String> doGetFileNames() throws IOException {
		return getFileNames(
			new String[] {
				"**/.bnd/**", "**/.idea/**", "**/.ivy/**", "**/bin/**",
				"**/javadocs-*.xml", "**/logs/**", "**/modules/**/.project",
				"**/portal-impl/**/*.action", "**/portal-impl/**/*.function",
				"**/portal-impl/**/*.macro", "**/portal-impl/**/*.testcase",
				"**/src/test/**", "**/test-classes/unit/**",
				"**/test-results/**", "**/test/unit/**", "**/tools/node**"
			},
			getIncludes());
	}

	@Override
	protected String[] doGetIncludes() {
		return _INCLUDES;
	}

	@Override
	protected File format(
			File file, String fileName, String absolutePath, String content)
		throws Exception {

		if ((fileName.endsWith(".function") || fileName.endsWith(".macro") ||
			 fileName.endsWith(".project") ||
			 fileName.endsWith(".properties") ||
			 fileName.endsWith(".testcase")) &&
			!SourceUtil.isXML(content)) {

			return file;
		}

		return super.format(file, fileName, absolutePath, content);
	}

	@Override
	protected boolean hasGeneratedTag(String content) {
		return _hasGeneratedTag(content, "@generated", "<!-- Generated");
	}

	private boolean _hasGeneratedTag(String content, String... tags) {
		for (String tag : tags) {
			if (!content.contains(tag)) {
				continue;
			}

			int pos = -1;

			while (true) {
				pos = content.indexOf(tag, pos + 1);

				if (pos == -1) {
					break;
				}

				if (!XMLSourceUtil.isInsideCDATAMarkup(content, pos)) {
					return true;
				}
			}
		}

		return false;
	}

	private static final String[] _INCLUDES = {
		"**/*.action", "**/*.function", "**/*.jrxml", "**/*.macro", "**/*.pom",
		"**/*.project", "**/*.properties", "**/*.testcase", "**/*.toggle",
		"**/*.wsdl", "**/*.xml", "**/definitions/liferay-*.xsd", "**/*.xml.tpl"
	};

}