/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter;

import com.liferay.petra.string.StringPool;
import com.liferay.portal.tools.ImportPackage;

/**
 * @author Alan Huang
 */
public class PythonImportPackage extends ImportPackage {

	public PythonImportPackage(String importString, String line) {
		super(importString, false, line);

		_importString = importString;
	}

	@Override
	public String getPackageLevel() {
		int pos = _importString.indexOf(StringPool.PERIOD);

		if (pos == -1) {
			return _importString;
		}

		return _importString.substring(0, pos);
	}

	private final String _importString;

}