/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter;

import java.io.IOException;

import java.util.List;

/**
 * @author Hugo Huijser
 */
public class CSSSourceProcessor extends BaseSourceProcessor {

	@Override
	protected List<String> doGetFileNames() throws IOException {
		return getFileNames(
			new String[] {
				"**/.ivy/**", "**/.sass-cache/**", "**/__MACOSX/**",
				"**/_partial.scss", "**/_styled/css/compat/third_party/**",
				"**/_unstyled/css/**", "**/aui/**", "**/aui_deprecated.css",
				"**/bourbon/**", "**/converter/dependencies/**",
				"**/expected/**", "**/frontend-editors-web/**",
				"**/tools/node**"
			},
			getIncludes());
	}

	@Override
	protected String[] doGetIncludes() {
		return _INCLUDES;
	}

	private static final String[] _INCLUDES = {"**/*.css", "**/*.scss"};

}