/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter;

import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.ModulesPropertiesUtil;

import java.io.File;
import java.io.IOException;

import java.util.List;

/**
 * @author Hugo Huijser
 */
public class BNDSourceProcessor extends BaseSourceProcessor {

	@Override
	protected List<String> doGetFileNames() throws IOException {
		return getFileNames(new String[0], getIncludes());
	}

	@Override
	protected String[] doGetIncludes() {
		return _INCLUDES;
	}

	@Override
	protected void postFormat() throws IOException {
		if (!_checkModulesPropertiesFile()) {
			return;
		}

		File modulesPropertiesFile = new File(
			getPortalDir(), "modules/modules.properties");

		String newContent = ModulesPropertiesUtil.getContent(getPortalDir());
		String oldContent = FileUtil.read(modulesPropertiesFile);

		if (!oldContent.equals(newContent)) {
			FileUtil.write(modulesPropertiesFile, newContent);

			System.out.println("Updated 'modules.properties'");
		}
	}

	private boolean _checkModulesPropertiesFile() {
		if (!isPortalSource()) {
			return false;
		}

		SourceFormatterArgs sourceFormatterArgs = getSourceFormatterArgs();

		List<String> fileExtensions = sourceFormatterArgs.getFileExtensions();

		if (!fileExtensions.contains("bnd")) {
			return false;
		}

		return true;
	}

	private static final String[] _INCLUDES = {"**/*.bnd"};

}