/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.poshi.core.util;

import java.util.Random;

/**
 * @author Brian Wing Shun Chan
 */
public class MathUtil {

	public static int difference(Integer value1, Integer value2) {
		return value1 - value2;
	}

	public static boolean isGreaterThan(Integer value1, Integer value2) {
		if (value1 > value2) {
			return true;
		}

		return false;
	}

	public static boolean isGreaterThanOrEqualTo(
		Integer value1, Integer value2) {

		if (value1 >= value2) {
			return true;
		}

		return false;
	}

	public static boolean isLessThan(Integer value1, Integer value2) {
		if (value1 < value2) {
			return true;
		}

		return false;
	}

	public static boolean isLessThanOrEqualTo(Integer value1, Integer value2) {
		if (value1 <= value2) {
			return true;
		}

		return false;
	}

	public static int percent(Integer percent, Integer value) {
		return quotient(product(percent, value), 100, true);
	}

	public static int product(Integer value1, Integer value2) {
		return value1 * value2;
	}

	public static int quotient(Integer value1, Integer value2) {
		return value1 / value2;
	}

	public static int quotient(Integer value1, Integer value2, boolean ceil) {
		if (ceil) {
			return (value1 + value2 - 1) / value2;
		}

		return quotient(value1, value2);
	}

	public static int randomNumber(Integer maxValue) {
		Random random = new Random(System.nanoTime());

		return random.nextInt(maxValue) + 1;
	}

	public static int sum(Integer value1, Integer value2) {
		return value1 + value2;
	}

}