/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.poshi.core.pql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

/**
 * @author Michael Hashimoto
 */
public abstract class PQLOperator {

	public static Set<String> getAvailableOperators() {
		return _availableOperators;
	}

	public static List<List<String>> getPrioritizedOperatorList() {
		return _prioritizedOperatorList;
	}

	public static void validateOperator(String operator) throws Exception {
		if ((operator == null) || !_availableOperators.contains(operator)) {
			throw new Exception("Invalid operator: " + operator);
		}
	}

	public PQLOperator(String operator) throws Exception {
		validateOperator(operator);

		_operator = operator;
	}

	public String getOperator() {
		return _operator;
	}

	public abstract Object getPQLResult(
			PQLEntity pqlEntity1, PQLEntity pqlEntity2, Properties properties)
		throws Exception;

	private static final Set<String> _availableOperators = new HashSet<>();
	private static final List<List<String>> _prioritizedOperatorList =
		new ArrayList<List<String>>() {
			{
				add(Arrays.asList("<", ">"));
				add(Arrays.asList("<=", ">="));
				add(Arrays.asList("~", "=="));
				add(Arrays.asList("!~", "!="));
				add(Arrays.asList("OR"));
				add(Arrays.asList("AND"));
			}
		};

	static {
		for (List<String> operators : _prioritizedOperatorList) {
			_availableOperators.addAll(operators);
		}
	}

	private final String _operator;

}