/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.poshi.core.pql;

/**
 * @author Michael Hashimoto
 */
public class PQLModifierFactory {

	public static PQLModifier newPQLModifier(String modifier) throws Exception {
		PQLModifier.validateModifier(modifier);

		if (modifier.equals("NOT")) {
			return new PQLModifier(modifier) {

				public Object getPQLResult(Object pqlResultObject)
					throws Exception {

					if ((pqlResultObject == null) ||
						!(pqlResultObject instanceof Boolean)) {

						throw new Exception(
							"Modifier must be used with a boolean value: " +
								getModifier());
					}

					Boolean pqlResultBoolean = (Boolean)pqlResultObject;

					return !pqlResultBoolean;
				}

			};
		}

		throw new Exception("Unsupported modifier: " + modifier);
	}

}