/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.poshi.core.pql;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/**
 * @author Michael Hashimoto
 */
public abstract class PQLModifier {

	public static Set<String> getAvailableModifiers() {
		return _availableModifiers;
	}

	public static void validateModifier(String modifier) throws Exception {
		if ((modifier == null) || !_availableModifiers.contains(modifier)) {
			throw new Exception("Invalid modifier: " + modifier);
		}
	}

	public PQLModifier(String modifier) throws Exception {
		validateModifier(modifier);

		_modifier = modifier;
	}

	public String getModifier() {
		return _modifier;
	}

	public abstract Object getPQLResult(Object pqlResultObject)
		throws Exception;

	private static final Set<String> _availableModifiers = new HashSet<>(
		Arrays.asList("NOT"));

	private final String _modifier;

}