/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.petra.nio;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;

/**
 * @author Shuyang Zhou
 */
public class CharsetEncoderUtil {

	public static ByteBuffer encode(String charsetName, CharBuffer charBuffer) {
		try {
			return encode(charsetName, CodingErrorAction.REPLACE, charBuffer);
		}
		catch (CharacterCodingException cce) {
			throw new Error(cce);
		}
	}

	public static ByteBuffer encode(
			String charsetName, CodingErrorAction codingErrorAction,
			CharBuffer charBuffer)
		throws CharacterCodingException {

		CharsetEncoder charsetEncoder = getCharsetEncoder(
			charsetName, codingErrorAction);

		return charsetEncoder.encode(charBuffer);
	}

	public static CharsetEncoder getCharsetEncoder(String charsetName) {
		return getCharsetEncoder(charsetName, CodingErrorAction.REPLACE);
	}

	public static CharsetEncoder getCharsetEncoder(
		String charsetName, CodingErrorAction codingErrorAction) {

		Charset charset = Charset.forName(charsetName);

		CharsetEncoder charsetEncoder = charset.newEncoder();

		charsetEncoder.onMalformedInput(codingErrorAction);
		charsetEncoder.onUnmappableCharacter(codingErrorAction);

		return charsetEncoder;
	}

}