/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.petra.nio;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;

/**
 * @author Shuyang Zhou
 */
public class CharsetDecoderUtil {

	public static CharBuffer decode(String charsetName, ByteBuffer byteBuffer) {
		try {
			return decode(charsetName, CodingErrorAction.REPLACE, byteBuffer);
		}
		catch (CharacterCodingException cce) {
			throw new Error(cce);
		}
	}

	public static CharBuffer decode(
			String charsetName, CodingErrorAction codingErrorAction,
			ByteBuffer byteBuffer)
		throws CharacterCodingException {

		CharsetDecoder charsetDecoder = getCharsetDecoder(
			charsetName, codingErrorAction);

		return charsetDecoder.decode(byteBuffer);
	}

	public static CharsetDecoder getCharsetDecoder(String charsetName) {
		return getCharsetDecoder(charsetName, CodingErrorAction.REPLACE);
	}

	public static CharsetDecoder getCharsetDecoder(
		String charsetName, CodingErrorAction codingErrorAction) {

		Charset charset = Charset.forName(charsetName);

		CharsetDecoder charsetDecoder = charset.newDecoder();

		charsetDecoder.onMalformedInput(codingErrorAction);
		charsetDecoder.onUnmappableCharacter(codingErrorAction);

		return charsetDecoder;
	}

}