/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.ArrayList;
import java.util.List;

public class VariableDeclarationAsUsedCheck
extends BaseCheck {
    private static final String _MSG_VARIABLE_DECLARATION_MOVE_AFTER_BRANCHING_STATEMENT = "variable.declaration.move.after.branching.statement";
    private static final String _MSG_VARIABLE_DECLARATION_MOVE_INSIDE_IF_STATEMENT = "variable.declaration.move.inside.if.statement";
    private static final String _MSG_VARIABLE_DECLARATION_NOT_NEEDED = "variable.declaration.not.needed";

    public int[] getDefaultTokens() {
        return new int[]{8, 9};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        List<DetailAST> variableDefinitionDetailASTList = this.getAllChildTokens(detailAST, true, 10);
        if (variableDefinitionDetailASTList.isEmpty()) {
            return;
        }
        for (DetailAST variableDefinitionDetailAST : variableDefinitionDetailASTList) {
            this._checkAsUsed(detailAST, variableDefinitionDetailAST);
        }
    }

    private void _checkAsUsed(DetailAST detailAST, DetailAST variableDefinitionDetailAST) {
        if (this.hasParentWithTokenType(variableDefinitionDetailAST, 156, 35)) {
            return;
        }
        DetailAST nameDetailAST = variableDefinitionDetailAST.findFirstToken(58);
        List<DetailAST> dependentIdentDetailASTList = this.getDependentIdentDetailASTList(variableDefinitionDetailAST, variableDefinitionDetailAST.getLineNo());
        if (dependentIdentDetailASTList.isEmpty()) {
            return;
        }
        String variableName = nameDetailAST.getText();
        DetailAST firstDependentIdentDetailAST = dependentIdentDetailASTList.get(0);
        if (!this._containsMethodName(variableDefinitionDetailAST, StringBundler.concat("_?(add|channel|close|copy|create|delete|execute|import|", "manage|next|open|post|put|read|register|resolve|run|send|", "test|transform|unzip|update|zip)([A-Z].*)?"), "currentTimeMillis", "nextVersion", "toString") && !this._containsVariableType(variableDefinitionDetailAST, "ActionQueue", "File")) {
            this._checkMoveAfterBranchingStatement(detailAST, variableDefinitionDetailAST, variableName, firstDependentIdentDetailAST);
            this._checkMoveInsideIfStatement(variableDefinitionDetailAST, nameDetailAST, variableName, dependentIdentDetailASTList);
        }
        this._checkInline(variableDefinitionDetailAST, nameDetailAST, variableName, firstDependentIdentDetailAST);
    }

    private void _checkInline(DetailAST variableDefinitionDetailAST, DetailAST nameDetailAST, String variableName, DetailAST firstDependentIdentDetailAST) {
        DetailAST parentDetailAST;
        DetailAST assignMethodCallDetailAST = this._getAssignMethodCallDetailAST(variableDefinitionDetailAST);
        if (assignMethodCallDetailAST == null) {
            return;
        }
        ArrayList<DetailAST> followingIdentDetailASTList = new ArrayList<DetailAST>();
        for (DetailAST nextSiblingDetailAST = variableDefinitionDetailAST.getNextSibling(); nextSiblingDetailAST != null; nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling()) {
            followingIdentDetailASTList.addAll(this.getAllChildTokens(nextSiblingDetailAST, true, 58));
        }
        DetailAST identDetailAST = null;
        for (DetailAST curIdentDetailAST : followingIdentDetailASTList) {
            if (curIdentDetailAST.getLineNo() <= nameDetailAST.getLineNo() || !variableName.equals(curIdentDetailAST.getText())) continue;
            if (identDetailAST != null) {
                return;
            }
            identDetailAST = curIdentDetailAST;
            DetailAST parentDetailAST2 = identDetailAST.getParent();
            if (parentDetailAST2.getType() == 132) {
                parentDetailAST2 = parentDetailAST2.getParent();
            }
            if (parentDetailAST2.getType() == 28) continue;
            return;
        }
        if (identDetailAST == null || firstDependentIdentDetailAST.getLineNo() < identDetailAST.getLineNo()) {
            return;
        }
        if (this._hasChainStyle(assignMethodCallDetailAST, "build", "map", "put")) {
            if (this._isInsideStatementClause(identDetailAST)) {
                return;
            }
        } else {
            if (this.getStartLineNumber(assignMethodCallDetailAST) != this.getEndLineNumber(assignMethodCallDetailAST) || this._isInsideStatementClause(identDetailAST) && this.hasParentWithTokenType(identDetailAST, RELATIONAL_OPERATOR_TOKEN_TYPES)) {
                return;
            }
            DetailAST firstChildDetailAST = assignMethodCallDetailAST.getFirstChild();
            FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)firstChildDetailAST);
            String methodName = fullIdent.getText();
            if (!methodName.matches("(?i)([\\w.]*\\.)?get" + variableName)) {
                return;
            }
        }
        if ((parentDetailAST = this.getParentWithTokenType(identDetailAST, 181, 85, 91, 136, 67, 95, 84)) != null && parentDetailAST.getLineNo() >= variableDefinitionDetailAST.getLineNo()) {
            return;
        }
        int emptyLineCount = 0;
        for (int i = variableDefinitionDetailAST.getLineNo(); i <= identDetailAST.getLineNo(); ++i) {
            if (!Validator.isNull(this.getLine(i - 1)) || ++emptyLineCount <= 1) continue;
            return;
        }
        this.log(variableDefinitionDetailAST, _MSG_VARIABLE_DECLARATION_NOT_NEEDED, new Object[]{variableName, identDetailAST.getLineNo()});
    }

    private void _checkMoveAfterBranchingStatement(DetailAST detailAST, DetailAST variableDefinitionDetailAST, String variableName, DetailAST firstDependentIdentDetailAST) {
        int endLineNumber = this.getEndLineNumber(variableDefinitionDetailAST);
        DetailAST lastBranchingStatementDetailAST = this._getLastBranchingStatementDetailAST(detailAST, endLineNumber, this._getClosestParentLineNumber(firstDependentIdentDetailAST, endLineNumber));
        if (lastBranchingStatementDetailAST != null) {
            this.log(variableDefinitionDetailAST, _MSG_VARIABLE_DECLARATION_MOVE_AFTER_BRANCHING_STATEMENT, new Object[]{variableName, lastBranchingStatementDetailAST.getText(), lastBranchingStatementDetailAST.getLineNo()});
        }
    }

    private void _checkMoveInsideIfStatement(DetailAST variableDefinitionDetailAST, DetailAST nameDetailAST, String variableName, List<DetailAST> dependentIdentDetailASTList) {
        DetailAST ifStatementDetailAST = this._getIfStatementDetailAST(dependentIdentDetailASTList.get(0), this.getEndLineNumber(variableDefinitionDetailAST));
        if (ifStatementDetailAST == null) {
            return;
        }
        DetailAST parentDetailAST = this.getParentWithTokenType(ifStatementDetailAST, 181, 85, 91, 136, 67, 95, 84);
        if (parentDetailAST != null && parentDetailAST.getLineNo() >= variableDefinitionDetailAST.getLineNo()) {
            return;
        }
        DetailAST slistDetailAST = ifStatementDetailAST.findFirstToken(7);
        DetailAST lastDependentIdentDetailAST = dependentIdentDetailASTList.get(dependentIdentDetailASTList.size() - 1);
        if (this.getEndLineNumber(slistDetailAST) > lastDependentIdentDetailAST.getLineNo()) {
            this.log(nameDetailAST, _MSG_VARIABLE_DECLARATION_MOVE_INSIDE_IF_STATEMENT, new Object[]{variableName, ifStatementDetailAST.getLineNo()});
        }
    }

    private boolean _containsMethodName(DetailAST variableDefinitionDetailAST, String ... methodNameRegexArray) {
        List<DetailAST> methodCallDetailASTList = this.getAllChildTokens(variableDefinitionDetailAST, true, 27);
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            String methodName = this.getMethodName(methodCallDetailAST);
            for (String methodNameRegex : methodNameRegexArray) {
                if (!methodName.matches(methodNameRegex)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean _containsVariableType(DetailAST variableDefinitionDetailAST, String ... variableTypeNames) {
        List<DetailAST> identDetailASTList = this.getAllChildTokens(variableDefinitionDetailAST, true, 58);
        for (DetailAST identDetailAST : identDetailASTList) {
            if (!ArrayUtil.contains(variableTypeNames, this.getVariableTypeName(identDetailAST, identDetailAST.getText(), false))) continue;
            return true;
        }
        return false;
    }

    private DetailAST _getAssignMethodCallDetailAST(DetailAST variableDefinitionDetailAST) {
        DetailAST assignDetailAST = variableDefinitionDetailAST.findFirstToken(80);
        if (assignDetailAST == null) {
            return null;
        }
        DetailAST firstChildDetailAST = assignDetailAST.getFirstChild();
        if (firstChildDetailAST == null || firstChildDetailAST.getType() != 28) {
            return null;
        }
        if ((firstChildDetailAST = firstChildDetailAST.getFirstChild()) != null && firstChildDetailAST.getType() == 27) {
            return firstChildDetailAST;
        }
        return null;
    }

    private int _getClosestParentLineNumber(DetailAST firstNameDetailAST, int lineNumber) {
        int closestLineNumber = firstNameDetailAST.getLineNo();
        DetailAST parentDetailAST = firstNameDetailAST.getParent();
        while (parentDetailAST.getLineNo() > lineNumber) {
            closestLineNumber = parentDetailAST.getLineNo();
            parentDetailAST = parentDetailAST.getParent();
        }
        return closestLineNumber;
    }

    private DetailAST _getIfStatementDetailAST(DetailAST detailAST, int lineNumber) {
        DetailAST ifStatementDetailAST = null;
        DetailAST slistDetailAST = this.getParentWithTokenType(detailAST, 7);
        while (slistDetailAST != null && slistDetailAST.getLineNo() >= lineNumber) {
            DetailAST parentDetailAST = slistDetailAST.getParent();
            if (parentDetailAST.getType() == 83) {
                ifStatementDetailAST = parentDetailAST;
            }
            slistDetailAST = this.getParentWithTokenType(slistDetailAST, 7);
        }
        return ifStatementDetailAST;
    }

    private DetailAST _getLastBranchingStatementDetailAST(DetailAST detailAST, int start, int end) {
        DetailAST lastBranchingStatementDetailAST = null;
        List<DetailAST> branchingStatementDetailASTList = this.getAllChildTokens(detailAST, true, 86, 87, 88);
        for (DetailAST branchingStatementDetailAST : branchingStatementDetailASTList) {
            int lineNumber = this.getEndLineNumber(branchingStatementDetailAST);
            if (start >= lineNumber || end <= lineNumber) continue;
            DetailAST branchedStatementDetailAST = null;
            branchedStatementDetailAST = branchingStatementDetailAST.getType() == 86 || branchingStatementDetailAST.getType() == 87 ? this.getParentWithTokenType(branchingStatementDetailAST, 85, 91, 84) : this.getParentWithTokenType(branchingStatementDetailAST, 8, 181, 9);
            if (branchedStatementDetailAST == null || branchedStatementDetailAST.getLineNo() >= start || lastBranchingStatementDetailAST != null && branchingStatementDetailAST.getLineNo() <= lastBranchingStatementDetailAST.getLineNo()) continue;
            lastBranchingStatementDetailAST = branchingStatementDetailAST;
        }
        return lastBranchingStatementDetailAST;
    }

    private boolean _hasChainStyle(DetailAST methodCallDetailAST, String ... methodNames) {
        int startLineNumber = this.getStartLineNumber(methodCallDetailAST);
        String line = this.getLine(startLineNumber - 1);
        if (!line.endsWith("(") || ToolsUtil.getLevel(line) != 1) {
            return false;
        }
        for (String methodName : methodNames) {
            if (!line.endsWith("." + methodName + "(")) continue;
            int level = 1;
            for (int i = startLineNumber + 1; i <= this.getEndLineNumber(methodCallDetailAST); ++i) {
                line = StringUtil.trim(this.getLine(i - 1));
                if (line.startsWith(").") && level == 1) {
                    return true;
                }
                level += ToolsUtil.getLevel(line);
            }
        }
        return false;
    }

    private boolean _isInsideStatementClause(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        DetailAST grandParentDetailAST;
        while ((grandParentDetailAST = parentDetailAST.getParent()) != null) {
            if (grandParentDetailAST.getType() == 91) {
                return parentDetailAST.getType() == 36 || parentDetailAST.getType() == 156 || parentDetailAST.getType() == 35 || parentDetailAST.getType() == 37;
            }
            if (grandParentDetailAST.getType() == 95) {
                return parentDetailAST.getType() == 176;
            }
            if (grandParentDetailAST.getType() == 84) {
                return parentDetailAST.getType() == 28;
            }
            parentDetailAST = grandParentDetailAST;
        }
        return false;
    }
}

