/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class FrameworkBundleCheck
extends BaseCheck {
    private static final String _MSG_USE_BUNDLE_GET_HEADERS = "bundle.get.headers.use";

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST != null) {
            return;
        }
        List<String> importNames = this.getImportNames(detailAST);
        if (!importNames.contains("org.osgi.framework.Bundle")) {
            return;
        }
        List<DetailAST> detailASTList = this.getAllChildTokens(detailAST, true, 8, 9);
        for (DetailAST curDetailAST : detailASTList) {
            this._checkGetHeadersMethodCall(curDetailAST);
        }
    }

    private void _checkGetHeadersMethodCall(DetailAST detailAST) {
        List<DetailAST> methodCallDetailASTList = this.getMethodCalls(detailAST, "getHeaders");
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            String variableTypeName;
            DetailAST elistDetailAST = methodCallDetailAST.findFirstToken(34);
            List<DetailAST> exprDetailASTList = this.getAllChildTokens(elistDetailAST, false, 28);
            if (!exprDetailASTList.isEmpty() || !(variableTypeName = this.getVariableTypeName(methodCallDetailAST, this.getVariableName(methodCallDetailAST), false)).equals("Bundle")) continue;
            this.log(methodCallDetailAST, _MSG_USE_BUNDLE_GET_HEADERS, new Object[0]);
        }
    }
}

