/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaComponentActivateCheck
extends BaseJavaTermCheck {
    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        List<String> importNames = this.getImportNames(javaTerm);
        if (importNames.isEmpty()) {
            return javaTerm.getContent();
        }
        return this._formatModifiers(fileName, javaTerm, importNames, "Activate", "Deactivate");
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_METHOD};
    }

    private String _formatModifiers(String fileName, JavaTerm javaTerm, List<String> importNames, String ... annotationNames) {
        String content = javaTerm.getContent();
        for (String annotationName : annotationNames) {
            String expectedMethodName;
            if (!javaTerm.hasAnnotation(annotationName) || !importNames.contains("org.osgi.service.component.annotations." + annotationName)) continue;
            String methodName = javaTerm.getName();
            if (!javaTerm.hasAnnotation("Override") && !methodName.equals(expectedMethodName = StringUtil.toLowerCase(annotationName))) {
                this.addMessage(fileName, StringBundler.concat("Method with annotation '", annotationName, "' should have name '", expectedMethodName, "'"));
            }
            if (javaTerm.isProtected()) continue;
            Pattern pattern = Pattern.compile(StringBundler.concat("(\\s)", javaTerm.getAccessModifier(), "( (.* )?void\\s*", javaTerm.getName(), ")"));
            Matcher matcher = pattern.matcher(content);
            if (matcher.find()) {
                return StringUtil.replaceFirst(content, javaTerm.getAccessModifier(), "protected", matcher.start());
            }
            this.addMessage(fileName, "Method '" + javaTerm.getName() + "' should be protected", javaTerm.getLineNumber(matcher.start()));
        }
        return content;
    }
}

