/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.util;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.GitException;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class GitUtil {
    private static final String _WORKING_BRANCH_NAME = "master";

    public static List<String> getCurrentBranchFileNames(String baseDirName) throws Exception {
        UnsyncBufferedReader unsyncBufferedReader = GitUtil.getGitCommandReader("git merge-base HEAD master");
        String mergeBaseCommitId = unsyncBufferedReader.readLine();
        return GitUtil.getFileNames(baseDirName, mergeBaseCommitId);
    }

    public static List<String> getLatestAuthorFileNames(String baseDirName) throws Exception {
        UnsyncBufferedReader unsyncBufferedReader = GitUtil.getGitCommandReader("git log");
        String line = null;
        String firstDifferentAuthorCommitId = null;
        String latestAuthor = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (line.startsWith("commit ")) {
                firstDifferentAuthorCommitId = line.substring(7);
                continue;
            }
            if (!line.startsWith("Author: ")) continue;
            if (latestAuthor == null) {
                int x = line.lastIndexOf(60);
                int y = line.lastIndexOf(62);
                latestAuthor = line.substring(x + 1, y);
                continue;
            }
            if (line.endsWith("<" + latestAuthor + ">")) continue;
            break;
        }
        return GitUtil.getFileNames(baseDirName, firstDifferentAuthorCommitId);
    }

    public static List<String> getLocalChangesFileNames(String baseDirName) throws Exception {
        ArrayList<String> localChangesFileNames = new ArrayList<String>();
        UnsyncBufferedReader unsyncBufferedReader = GitUtil.getGitCommandReader("git add . --dry-run");
        String line = null;
        int gitLevel = GitUtil.getGitLevel(baseDirName);
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (!line.startsWith("add '") || StringUtil.count(line, "/") < gitLevel) continue;
            String fileName = GitUtil.getFileName(line.substring(5, line.length() - 1), gitLevel);
            localChangesFileNames.add(fileName);
        }
        return localChangesFileNames;
    }

    protected static String getFileName(String fileName, int gitLevel) {
        for (int i = 0; i < gitLevel; ++i) {
            int x = fileName.indexOf("/");
            fileName = fileName.substring(x + 1);
        }
        return fileName;
    }

    protected static List<String> getFileNames(String baseDirName, String commitId) throws Exception {
        ArrayList<String> fileNames = new ArrayList<String>();
        String line = null;
        int gitLevel = GitUtil.getGitLevel(baseDirName);
        UnsyncBufferedReader unsyncBufferedReader = GitUtil.getGitCommandReader("git diff --diff-filter=AM --name-only HEAD " + commitId);
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (StringUtil.count(line, "/") < gitLevel) continue;
            fileNames.add(GitUtil.getFileName(line, gitLevel));
        }
        return fileNames;
    }

    protected static UnsyncBufferedReader getGitCommandReader(String gitCommand) throws Exception {
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        try {
            process = runtime.exec(gitCommand);
        }
        catch (IOException ioe) {
            String errorMessage = ioe.getMessage();
            if (errorMessage.contains("Cannot run program")) {
                throw new GitException("Add Git to your PATH system variable first.");
            }
            throw ioe;
        }
        return new UnsyncBufferedReader(new InputStreamReader(process.getInputStream()));
    }

    protected static int getGitLevel(String baseDirName) throws GitException {
        for (int i = 0; i < 5; ++i) {
            File file = new File(baseDirName + ".git");
            if (file.exists()) {
                return i;
            }
            baseDirName = "../" + baseDirName;
        }
        throw new GitException("Unable to retrieve files because .git directory is missing.");
    }
}

