/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.welcome.site.initializer.internal.instance.lifecycle;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.instance.lifecycle.InitialRequestPortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.InvokerPortlet;
import com.liferay.portal.kernel.portlet.LiferayRenderRequest;
import com.liferay.portal.kernel.portlet.PortletConfigFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletInstanceFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.ThemeLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.servlet.DummyHttpServletResponse;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ColorSchemeFactoryUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizer;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PrefsProps;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.RenderRequestFactory;
import com.liferay.portlet.RenderResponseFactory;
import com.liferay.site.initializer.SiteInitializer;
import com.liferay.site.initializer.SiteInitializerRegistry;
import java.util.List;
import java.util.Objects;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.WindowState;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={PortalInstanceLifecycleListener.class})
public class AddDefaultLayoutInitialRequestPortalInstanceLifecycleListener
extends InitialRequestPortalInstanceLifecycleListener {
    private static final String _SITE_INITIALIZER_KEY_BLANK = "blank-site-initializer";
    private static final String _SITE_INITIALIZER_KEY_WELCOME = "com.liferay.site.initializer.welcome";
    private static final Log _log = LogFactoryUtil.getLog(AddDefaultLayoutInitialRequestPortalInstanceLifecycleListener.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private PermissionCheckerFactory _defaultPermissionCheckerFactory;
    @Reference
    private FriendlyURLNormalizer _friendlyURLNormalizer;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private PrefsProps _prefsProps;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private SiteInitializerRegistry _siteInitializerRegistry;
    @Reference
    private ThemeLocalService _themeLocalService;
    @Reference
    private UserLocalService _userLocalService;

    @Activate
    protected void activate(BundleContext bundleContext) {
        super.activate(bundleContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPortalInstanceRegistered(long companyId) throws Exception {
        Group group = this._groupLocalService.getGroup(companyId, "Guest");
        String friendlyURL = this._friendlyURLNormalizer.normalizeWithEncoding(PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_FRIENDLY_URL);
        Layout defaultLayout = this._layoutLocalService.fetchLayoutByFriendlyURL(group.getGroupId(), false, friendlyURL);
        if (defaultLayout != null) {
            return;
        }
        defaultLayout = this._layoutLocalService.fetchFirstLayout(group.getGroupId(), false, 0L, false);
        if (defaultLayout != null) {
            return;
        }
        String name = PrincipalThreadLocal.getName();
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        ServiceContext currentThreadServiceContext = ServiceContextThreadLocal.getServiceContext();
        if (currentThreadServiceContext == null) {
            currentThreadServiceContext = new ServiceContext();
        }
        try (SafeCloseable safeCloseable = CompanyThreadLocal.setInitializingPortalInstanceWithSafeCloseable((boolean)true);){
            User user = this._getUser(companyId);
            PrincipalThreadLocal.setName((long)user.getUserId());
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)this._defaultPermissionCheckerFactory.create(user));
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)this._populateServiceContext(this._companyLocalService.getCompanyById(companyId), group, currentThreadServiceContext.getRequest(), permissionChecker, (ServiceContext)currentThreadServiceContext.clone(), user));
            UnicodeProperties typeSettingsUnicodeProperties = group.getTypeSettingsProperties();
            String siteInitializerKey = typeSettingsUnicodeProperties.getProperty("siteInitializerKey");
            if (Validator.isNull((String)siteInitializerKey)) {
                siteInitializerKey = _SITE_INITIALIZER_KEY_WELCOME;
            }
            if (!Objects.equals(siteInitializerKey, _SITE_INITIALIZER_KEY_WELCOME) && !Objects.equals(siteInitializerKey, _SITE_INITIALIZER_KEY_BLANK)) {
                this._layoutLocalService.deleteLayouts(group.getGroupId(), false, new ServiceContext());
            }
            SiteInitializer siteInitializer = this._siteInitializerRegistry.getSiteInitializer(siteInitializerKey);
            siteInitializer.initialize(group.getGroupId());
        }
        finally {
            PrincipalThreadLocal.setName((String)name);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
            ServiceContextThreadLocal.popServiceContext();
        }
    }

    private User _getUser(long companyId) throws PortalException {
        Role role = this._roleLocalService.fetchRole(companyId, "Administrator");
        if (role == null) {
            return this._userLocalService.getGuestUser(companyId);
        }
        List adminUsers = this._userLocalService.getRoleUsers(role.getRoleId(), 0, 1);
        if (adminUsers.isEmpty()) {
            return this._userLocalService.getGuestUser(companyId);
        }
        return (User)adminUsers.get(0);
    }

    private ServiceContext _populateServiceContext(Company company, Group group, HttpServletRequest httpServletRequest, PermissionChecker permissionChecker, ServiceContext serviceContext, User user) throws PortalException {
        serviceContext.setCompanyId(user.getCompanyId());
        serviceContext.setRequest(httpServletRequest);
        serviceContext.setScopeGroupId(group.getGroupId());
        serviceContext.setUserId(user.getUserId());
        if (httpServletRequest == null) {
            return serviceContext;
        }
        long controlPanelPlid = this._portal.getControlPanelPlid(company.getCompanyId());
        Layout controlPanelLayout = this._layoutLocalService.getLayout(controlPanelPlid);
        httpServletRequest.setAttribute("LAYOUT", (Object)controlPanelLayout);
        ThemeDisplay currentThemeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        ThemeDisplay themeDisplay = null;
        if (currentThemeDisplay != null) {
            try {
                themeDisplay = (ThemeDisplay)currentThemeDisplay.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                _log.error((Throwable)cloneNotSupportedException);
            }
        } else {
            themeDisplay = new ThemeDisplay();
        }
        themeDisplay.setCompany(company);
        themeDisplay.setLayout(controlPanelLayout);
        themeDisplay.setLayoutSet(controlPanelLayout.getLayoutSet());
        themeDisplay.setLayoutTypePortlet((LayoutTypePortlet)controlPanelLayout.getLayoutType());
        themeDisplay.setLayouts(ListUtil.fromArray((Object[])new Layout[]{controlPanelLayout}));
        themeDisplay.setLocale(LocaleUtil.getSiteDefault());
        String themeId = this._prefsProps.getString(company.getCompanyId(), "control.panel.layout.regular.theme.id");
        themeDisplay.setLookAndFeel(this._themeLocalService.getTheme(company.getCompanyId(), themeId), ColorSchemeFactoryUtil.getDefaultRegularColorScheme());
        themeDisplay.setPermissionChecker(permissionChecker);
        themeDisplay.setPlid(controlPanelPlid);
        themeDisplay.setRealUser(user);
        themeDisplay.setRequest(httpServletRequest);
        themeDisplay.setScopeGroupId(controlPanelLayout.getGroupId());
        themeDisplay.setSiteGroupId(controlPanelLayout.getGroupId());
        themeDisplay.setUser(user);
        httpServletRequest.setAttribute("LIFERAY_SHARED_THEME_DISPLAY", (Object)themeDisplay);
        PortletRequest portletRequest = (PortletRequest)httpServletRequest.getAttribute("javax.portlet.request");
        if (portletRequest != null) {
            return serviceContext;
        }
        Portlet portlet = this._portletLocalService.getPortletById(0L, "90");
        try {
            InvokerPortlet invokerPortlet = PortletInstanceFactoryUtil.create((Portlet)portlet, (ServletContext)httpServletRequest.getServletContext());
            PortletConfig portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)httpServletRequest.getServletContext());
            LiferayRenderRequest liferayRenderRequest = RenderRequestFactory.create((HttpServletRequest)httpServletRequest, (Portlet)portlet, (InvokerPortlet)invokerPortlet, (PortletContext)portletConfig.getPortletContext(), (WindowState)WindowState.NORMAL, (PortletMode)PortletMode.VIEW, (PortletPreferences)PortletPreferencesFactoryUtil.fromDefaultXML((String)portlet.getDefaultPreferences()), (long)themeDisplay.getPlid());
            httpServletRequest.setAttribute("javax.portlet.request", (Object)liferayRenderRequest);
            httpServletRequest.setAttribute("javax.portlet.response", (Object)RenderResponseFactory.create((HttpServletResponse)new DummyHttpServletResponse(), (RenderRequest)liferayRenderRequest));
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        return serviceContext;
    }
}

