/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.navigation.internal.type;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.site.navigation.model.SiteNavigationMenuItem;
import com.liferay.site.navigation.type.SiteNavigationMenuItemType;
import com.liferay.site.navigation.type.SiteNavigationMenuItemTypeRegistry;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true, service={SiteNavigationMenuItemTypeRegistry.class})
public class SiteNavigationMenuItemTypeRegistryImpl
implements SiteNavigationMenuItemTypeRegistry {
    private final Map<String, SiteNavigationMenuItemType> _siteNavigationMenuItemTypes = new ConcurrentHashMap<String, SiteNavigationMenuItemType>();

    public SiteNavigationMenuItemType getSiteNavigationMenuItemType(SiteNavigationMenuItem siteNavigationMenuItem) {
        return this.getSiteNavigationMenuItemType(siteNavigationMenuItem.getType());
    }

    public SiteNavigationMenuItemType getSiteNavigationMenuItemType(String type) {
        return this._siteNavigationMenuItemTypes.get(type);
    }

    public List<SiteNavigationMenuItemType> getSiteNavigationMenuItemTypes() {
        return ListUtil.fromMapValues(this._siteNavigationMenuItemTypes);
    }

    public String[] getTypes() {
        Set<String> types = this._siteNavigationMenuItemTypes.keySet();
        return types.toArray(new String[0]);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void registerSiteNavigationMenuItemType(SiteNavigationMenuItemType siteNavigationMenuItemType) {
        this._siteNavigationMenuItemTypes.put(siteNavigationMenuItemType.getType(), siteNavigationMenuItemType);
    }

    public void unregisterSiteNavigationMenuItemType(SiteNavigationMenuItemType siteNavigationMenuItemType) {
        this._siteNavigationMenuItemTypes.remove(siteNavigationMenuItemType.getType());
    }
}

